/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ConfigVersion;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractBucketConfig
implements BucketConfig {
    private final String uuid;
    private final String name;
    private final BucketNodeLocator locator;
    private final String uri;
    private final String streamingUri;
    private final List<NodeInfo> nodeInfo;
    private final Set<ServiceType> enabledServices;
    private final Set<BucketCapabilities> bucketCapabilities;
    private final Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities;
    private final String origin;
    private final List<PortInfo> portInfos;
    private final ConfigVersion version;

    protected AbstractBucketConfig(String uuid, String name, BucketNodeLocator locator, String uri, String streamingUri, List<NodeInfo> nodeInfos, List<PortInfo> portInfos, List<BucketCapabilities> bucketCapabilities, String origin, Map<String, Set<ClusterCapabilities>> clusterCapabilities, long rev, long revEpoch) {
        this.uuid = uuid;
        this.name = name;
        this.locator = locator;
        this.uri = uri;
        this.streamingUri = streamingUri;
        this.bucketCapabilities = AbstractBucketConfig.convertBucketCapabilities(bucketCapabilities);
        this.clusterCapabilities = AbstractBucketConfig.convertClusterCapabilities(clusterCapabilities);
        this.origin = origin;
        this.version = new ConfigVersion(revEpoch, rev);
        this.portInfos = portInfos == null ? Collections.emptyList() : portInfos;
        this.nodeInfo = portInfos == null ? nodeInfos : this.nodeInfoFromExtended(portInfos, nodeInfos);
        EnumSet<ServiceType> es = EnumSet.noneOf(ServiceType.class);
        for (NodeInfo info : this.nodeInfo) {
            es.addAll(info.services().keySet());
            es.addAll(info.sslServices().keySet());
        }
        this.enabledServices = Collections.unmodifiableSet(es);
    }

    static Set<BucketCapabilities> convertBucketCapabilities(List<BucketCapabilities> input) {
        if (CbCollections.isNullOrEmpty(input)) {
            return Collections.emptySet();
        }
        return EnumSet.copyOf(input.stream().filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    static Map<ServiceType, Set<ClusterCapabilities>> convertClusterCapabilities(Map<String, Set<ClusterCapabilities>> input) {
        HashMap<ServiceType, Set<ClusterCapabilities>> result = new HashMap<ServiceType, Set<ClusterCapabilities>>();
        result.put(ServiceType.MANAGER, Collections.emptySet());
        result.put(ServiceType.QUERY, Collections.emptySet());
        result.put(ServiceType.VIEWS, Collections.emptySet());
        result.put(ServiceType.KV, Collections.emptySet());
        result.put(ServiceType.SEARCH, Collections.emptySet());
        result.put(ServiceType.ANALYTICS, Collections.emptySet());
        result.put(ServiceType.EVENTING, Collections.emptySet());
        result.put(ServiceType.BACKUP, Collections.emptySet());
        if (input == null) {
            return result;
        }
        for (Map.Entry<String, Set<ClusterCapabilities>> entry : input.entrySet()) {
            Set capabilities = entry.getValue().stream().filter(Objects::nonNull).collect(Collectors.toSet());
            if (capabilities.isEmpty()) continue;
            EnumSet filtered = EnumSet.copyOf(entry.getValue().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
            switch (entry.getKey()) {
                case "mgmt": {
                    result.put(ServiceType.MANAGER, filtered);
                    break;
                }
                case "n1ql": {
                    result.put(ServiceType.QUERY, filtered);
                    break;
                }
                case "capi": {
                    result.put(ServiceType.VIEWS, filtered);
                    break;
                }
                case "kv": {
                    result.put(ServiceType.KV, filtered);
                    break;
                }
                case "search": {
                    result.put(ServiceType.SEARCH, filtered);
                    break;
                }
                case "cbas": {
                    result.put(ServiceType.ANALYTICS, filtered);
                    break;
                }
                case "eventing": {
                    result.put(ServiceType.EVENTING, filtered);
                    break;
                }
                case "backup": {
                    result.put(ServiceType.BACKUP, filtered);
                }
            }
        }
        return result;
    }

    private List<NodeInfo> nodeInfoFromExtended(List<PortInfo> nodesExt, List<NodeInfo> nodeInfos) {
        ArrayList<NodeInfo> converted = new ArrayList<NodeInfo>(nodesExt.size());
        for (int i = 0; i < nodesExt.size(); ++i) {
            NodeInfo nodeInfo;
            String hostname = nodesExt.get(i).hostname();
            NodeInfo nodeInfo2 = nodeInfo = i >= nodeInfos.size() ? null : nodeInfos.get(i);
            if (hostname == null) {
                hostname = nodeInfo != null ? nodeInfo.hostname() : this.origin;
            }
            HashMap<ServiceType, Integer> ports = new HashMap<ServiceType, Integer>(nodesExt.get(i).ports());
            HashMap<ServiceType, Integer> sslPorts = new HashMap<ServiceType, Integer>(nodesExt.get(i).sslPorts());
            HashMap<String, AlternateAddress> aa = new HashMap<String, AlternateAddress>(nodesExt.get(i).alternateAddresses());
            if (!this.bucketCapabilities.contains((Object)BucketCapabilities.COUCHAPI)) {
                ports.remove((Object)ServiceType.VIEWS);
                sslPorts.remove((Object)ServiceType.VIEWS);
            }
            if (nodeInfo == null) {
                ports.remove((Object)ServiceType.KV);
                sslPorts.remove((Object)ServiceType.KV);
                ports.remove((Object)ServiceType.VIEWS);
                sslPorts.remove((Object)ServiceType.VIEWS);
            }
            converted.add(new NodeInfo(hostname, ports, sslPorts, aa));
        }
        return converted;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketNodeLocator locator() {
        return this.locator;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String streamingUri() {
        return this.streamingUri;
    }

    @Override
    public List<NodeInfo> nodes() {
        return this.nodeInfo;
    }

    @Override
    public long rev() {
        return this.version.rev();
    }

    @Override
    public long revEpoch() {
        return this.version.epoch();
    }

    @Override
    public ConfigVersion version() {
        return this.version;
    }

    @Override
    public boolean serviceEnabled(ServiceType type) {
        return this.enabledServices.contains((Object)type);
    }

    @Override
    public Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities() {
        return this.clusterCapabilities;
    }

    @Override
    public Set<BucketCapabilities> bucketCapabilities() {
        return this.bucketCapabilities;
    }

    @Override
    public List<PortInfo> portInfos() {
        return this.portInfos;
    }
}

