/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.EnumLookupTable;

@Stability.Internal
public enum ServerFeature {
    DATATYPE(1),
    TLS(2),
    TCPNODELAY(3),
    MUTATION_SEQNO(4),
    TCPDELAY(5),
    XATTR(6),
    XERROR(7),
    SELECT_BUCKET(8),
    SNAPPY(10),
    JSON(11),
    DUPLEX(12),
    CLUSTERMAP_CHANGE_NOTIFICATION(13),
    UNORDERED_EXECUTION(14),
    TRACING(15),
    ALT_REQUEST(16),
    SYNC_REPLICATION(17),
    COLLECTIONS(18),
    SNAPPY_EVERYWHERE(19),
    PRESERVE_TTL(20),
    VATTR(21),
    CREATE_AS_DELETED(23),
    REPORT_UNIT_USAGE(26),
    SUBDOC_READ_REPLICA(28),
    GET_CLUSTER_CONFIG_WITH_KNOWN_VERSION(29),
    DEDUPE_NOT_MY_VBUCKET_CLUSTERMAP(30),
    CLUSTERMAP_CHANGE_NOTIFICATION_BRIEF(31),
    SUBDOC_BINARY_XATTR(33);

    private static final EnumLookupTable<ServerFeature> lookupTable;
    private final int value;

    private ServerFeature(int value) {
        this.value = ServerFeature.require16Bit(value);
    }

    public int value() {
        return this.value;
    }

    private static int require16Bit(int value) {
        if ((value & 0xFFFF) != value) {
            throw new IllegalArgumentException("Expected a value that fits in 16 bits, but got: 0x" + Integer.toHexString(value));
        }
        return value;
    }

    static ServerFeature from(int input) {
        return lookupTable.getOrDefault(input, null);
    }

    static {
        lookupTable = EnumLookupTable.create(ServerFeature.class, ServerFeature::value);
    }
}

