/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.node.RoundRobinLocator;
import com.couchbase.client.core.service.ServiceType;

public class AnalyticsLocator
extends RoundRobinLocator {
    public AnalyticsLocator() {
        super(ServiceType.ANALYTICS);
    }

    @Override
    protected boolean checkServiceNotAvailable(Request<? extends Response> request, ClusterConfig config) {
        BucketConfig bc;
        AnalyticsRequest ar;
        if (request instanceof AnalyticsRequest && (ar = (AnalyticsRequest)request).scope() != null && ar.bucket() != null && (bc = config.bucketConfig(ar.bucket())) != null && !bc.bucketCapabilities().contains((Object)BucketCapabilities.COLLECTIONS)) {
            request.fail(FeatureNotAvailableException.scopeLevelQuery(ServiceType.ANALYTICS));
            return false;
        }
        return true;
    }
}

