/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

final class FormattedTime {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);

    private FormattedTime() {
    }

    public static String format(Instant date) {
        return DEFAULT_FORMAT.format(date);
    }

    public static Instant parse(String s) throws DateTimeParseException {
        if (s.length() == 14) {
            return DEFAULT_FORMAT.parse((CharSequence)s, Instant::from);
        }
        if (s.length() <= 10) {
            return Instant.ofEpochSecond(Long.parseLong(s));
        }
        throw new DateTimeParseException("Invalid time encoding: ", s, 0);
    }
}

