/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreVectorQuery {
    public static final int DEFAULT_NUM_CANDIDATES = 3;
    private final float[] vector;
    private final String field;
    @Nullable
    private final Integer numCandidates;
    @Nullable
    private final Double boost;

    public CoreVectorQuery(float[] vector, String field, @Nullable Integer numCandidates, @Nullable Double boost) {
        this.vector = Validators.notNull(vector, "Vector");
        this.numCandidates = numCandidates;
        this.field = Validators.notNullOrEmpty(field, "Field");
        this.boost = boost;
    }

    public ObjectNode toJson() {
        ObjectNode outer = Mapper.createObjectNode();
        ArrayNode array = Mapper.createArrayNode();
        for (float v : this.vector) {
            array.add(v);
        }
        outer.set("vector", array);
        outer.put("field", this.field);
        outer.put("k", this.numCandidates != null ? this.numCandidates : 3);
        if (this.boost != null) {
            outer.put("boost", this.boost);
        }
        return outer;
    }
}

