/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.result;

import com.couchbase.client.core.api.search.CoreSearchKeyset;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocations;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;

public class CoreSearchRow {
    private final String index;
    private final String id;
    private final double score;
    private final byte[] explanation;
    private final Optional<CoreSearchRowLocations> locations;
    private final Map<String, List<String>> fragments;
    private final byte[] fields;
    private final Supplier<CoreSearchKeyset> keyset;

    public CoreSearchRow(String index, String id, double score, @Nullable byte[] explanation, Optional<CoreSearchRowLocations> locations, Map<String, List<String>> fragments, byte[] fields, Supplier<CoreSearchKeyset> keyset) {
        this.index = index;
        this.id = id;
        this.score = score;
        this.explanation = explanation == null ? Bytes.EMPTY_BYTE_ARRAY : explanation;
        this.locations = locations;
        this.fragments = fragments;
        this.fields = fields;
        this.keyset = Objects.requireNonNull(keyset);
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public double score() {
        return this.score;
    }

    public byte[] explanation() {
        return this.explanation;
    }

    public Optional<CoreSearchRowLocations> locations() {
        return this.locations;
    }

    public Map<String, List<String>> fragments() {
        return this.fragments;
    }

    @Nullable
    public byte[] fields() {
        return this.fields;
    }

    public CoreSearchKeyset keyset() {
        return this.keyset.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreSearchRow searchRow = (CoreSearchRow)o;
        return Double.compare(searchRow.score, this.score) == 0 && Objects.equals(this.index, searchRow.index) && Objects.equals(this.id, searchRow.id) && Arrays.equals(this.explanation, searchRow.explanation) && Objects.equals(this.locations, searchRow.locations) && Objects.equals(this.fragments, searchRow.fragments) && Arrays.equals(this.fields, searchRow.fields);
    }

    public int hashCode() {
        int result = Objects.hash(this.index, this.id, this.score, this.explanation, this.locations, this.fragments);
        result = 31 * result + Arrays.hashCode(this.fields);
        return result;
    }

    public static CoreSearchRow fromResponse(SearchChunkRow row) {
        ObjectNode hit = (ObjectNode)Mapper.decodeIntoTree(row.data());
        return CoreSearchRow.fromResponse(hit);
    }

    public static CoreSearchRow fromResponse(ObjectNode hit) {
        Map<String, List<String>> fragments;
        String index = hit.get("index").textValue();
        String id = hit.get("id").textValue();
        double score = hit.get("score").doubleValue();
        byte[] explanation = CoreSearchRow.parseExplanation(hit);
        Optional<CoreSearchRowLocations> locations = Optional.ofNullable(hit.get("locations")).map(v -> CoreSearchRowLocations.from((ObjectNode)v));
        ObjectNode fragmentsJson = (ObjectNode)hit.get("fragments");
        if (fragmentsJson != null) {
            fragments = new HashMap(fragmentsJson.size());
            fragmentsJson.fieldNames().forEachRemaining(field -> {
                ArrayNode fragmentJson = (ArrayNode)fragmentsJson.get((String)field);
                List fragment = fragmentJson == null ? Collections.emptyList() : Mapper.convertValue((Object)fragmentJson, new TypeReference<List<String>>(){});
                fragments.put((String)field, fragment);
            });
        } else {
            fragments = Collections.emptyMap();
        }
        byte[] fields = null;
        if (hit.has("fields")) {
            fields = hit.get("fields").toString().getBytes(StandardCharsets.UTF_8);
        }
        Supplier<CoreSearchKeyset> keyset = CoreSearchRow.lazyParseKeyset(hit);
        return new CoreSearchRow(index, id, score, explanation, locations, fragments, fields, keyset);
    }

    @Nullable
    private static byte[] parseExplanation(ObjectNode hit) {
        JsonNode node = hit.get("explanation");
        return node == null ? null : Mapper.encodeAsBytes(node);
    }

    private static Supplier<CoreSearchKeyset> lazyParseKeyset(ObjectNode hit) {
        JsonNode keysetNode = hit.get("sort");
        if (keysetNode == null) {
            return () -> CoreSearchKeyset.EMPTY;
        }
        JsonNode scoreNode = hit.path("score");
        return () -> {
            ArrayList<String> keys = new ArrayList<String>(keysetNode.size());
            keysetNode.forEach(it -> keys.add(it.asText()));
            ListIterator<String> i = keys.listIterator();
            while (i.hasNext()) {
                if (!"_score".equals(i.next())) continue;
                i.set(scoreNode.asText());
                break;
            }
            return new CoreSearchKeyset(keys);
        };
    }

    public String toString() {
        return "SearchRow{index='" + RedactableArgument.redactMeta(this.index) + '\'' + ", id='" + this.id + '\'' + ", score=" + this.score + ", explanation=" + new String(this.explanation, StandardCharsets.UTF_8) + ", locations=" + RedactableArgument.redactUser(this.locations) + ", fragments=" + RedactableArgument.redactUser(this.fragments) + '}';
    }
}

