/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreAbstractCompoundQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.protostellar.search.v1.DisjunctionQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.List;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreDisjunctionQuery
extends CoreAbstractCompoundQuery {
    @Nullable
    private final Integer min;

    public CoreDisjunctionQuery(List<CoreSearchQuery> queries, @Nullable Integer min, @Nullable Double boost) {
        super(queries, boost);
        this.min = min;
        if (this.childQueries.isEmpty()) {
            throw InvalidArgumentException.fromMessage("Disjunction query has no child query");
        }
        if (min != null && this.childQueries.size() < min) {
            throw InvalidArgumentException.fromMessage("Disjunction query has fewer children than the configured minimum " + min);
        }
    }

    @Override
    protected void injectParams(ObjectNode input) {
        if (this.min != null && this.min > 1) {
            input.put("min", this.min);
        }
        ArrayNode disjuncts = Mapper.createArrayNode();
        for (CoreSearchQuery childQuery : this.childQueries) {
            ObjectNode childJson = Mapper.createObjectNode();
            childQuery.injectParamsAndBoost(childJson);
            disjuncts.add(childJson);
        }
        input.set("disjuncts", disjuncts);
    }

    @Override
    public Query asProtostellar() {
        return Query.newBuilder().setDisjunctionQuery(this.asDisjunctionProtostellar()).build();
    }

    public DisjunctionQuery asDisjunctionProtostellar() {
        DisjunctionQuery.Builder query = DisjunctionQuery.newBuilder().addAllQueries(this.childQueries.stream().map(CoreSearchQuery::asProtostellar).collect(Collectors.toList()));
        if (this.min != null && this.min > 1) {
            query.setMinimum(this.min);
        }
        if (this.boost != null) {
            query.setBoost(this.boost.floatValue());
        }
        return query.build();
    }
}

