/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.service.ServiceConfig;
import java.time.Duration;
import java.util.Objects;

public abstract class AbstractPooledEndpointServiceConfig
implements ServiceConfig {
    public static final int DEFAULT_MAX_ENDPOINTS = 12;
    public static final int DEFAULT_MIN_ENDPOINTS = 0;
    public static final Duration DEFAULT_IDLE_TIME = Duration.ofSeconds(1L);
    private final int minEndpoints;
    private final int maxEndpoints;
    private final Duration idleTime;

    AbstractPooledEndpointServiceConfig(Builder<?> builder) {
        this.minEndpoints = ((Builder)builder).minEndpoints;
        this.maxEndpoints = ((Builder)builder).maxEndpoints;
        this.idleTime = Objects.requireNonNull(((Builder)builder).idleTime);
    }

    @Override
    public int minEndpoints() {
        return this.minEndpoints;
    }

    @Override
    public int maxEndpoints() {
        return this.maxEndpoints;
    }

    @Override
    public Duration idleTime() {
        return this.idleTime;
    }

    @Override
    public boolean pipelined() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{minEndpoints=" + this.minEndpoints + ", maxEndpoints=" + this.maxEndpoints + ", idleTime=" + this.idleTime + '}';
    }

    public static abstract class Builder<SELF extends Builder<?>> {
        private int minEndpoints;
        private int maxEndpoints;
        private Duration idleTime;

        public SELF minEndpoints(int minEndpoints) {
            if (minEndpoints < 0) {
                throw InvalidArgumentException.fromMessage("minEndpoints must be >= 0 but got " + minEndpoints);
            }
            this.minEndpoints = minEndpoints;
            this.maxEndpoints = Math.max(this.maxEndpoints, minEndpoints);
            return this.self();
        }

        public SELF maxEndpoints(int maxEndpoints) {
            if (maxEndpoints < 1) {
                throw InvalidArgumentException.fromMessage("maxEndpoints must be >= 1 but got " + maxEndpoints);
            }
            this.maxEndpoints = maxEndpoints;
            this.minEndpoints = Math.min(maxEndpoints, this.minEndpoints);
            return this.self();
        }

        public SELF idleTime(Duration idleTime) {
            if (idleTime.isNegative()) {
                throw InvalidArgumentException.fromMessage("idleTime must be non-negative but got " + idleTime);
            }
            this.idleTime = Objects.requireNonNull(idleTime);
            return this.self();
        }

        private SELF self() {
            return (SELF)this;
        }
    }
}

