/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Compression;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSInput;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSKEYRecord;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSOutput;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSSEC;
import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.Record;
import com.couchbase.client.core.deps.org.xbill.DNS.Tokenizer;
import com.couchbase.client.core.deps.org.xbill.DNS.utils.base16;
import java.io.IOException;

public class DSRecord
extends Record {
    @Deprecated
    public static final int SHA1_DIGEST_ID = 1;
    @Deprecated
    public static final int SHA256_DIGEST_ID = 2;
    @Deprecated
    public static final int GOST3411_DIGEST_ID = 3;
    @Deprecated
    public static final int SHA384_DIGEST_ID = 4;
    private int footprint;
    private int alg;
    private int digestid;
    private byte[] digest;

    DSRecord() {
    }

    protected DSRecord(Name name, int type, int dclass, long ttl, int footprint, int alg, int digestid, byte[] digest) {
        super(name, type, dclass, ttl);
        this.footprint = DSRecord.checkU16("footprint", footprint);
        this.alg = DSRecord.checkU8("alg", alg);
        this.digestid = DSRecord.checkU8("digestid", digestid);
        this.digest = digest;
    }

    public DSRecord(Name name, int dclass, long ttl, int footprint, int alg, int digestid, byte[] digest) {
        this(name, 43, dclass, ttl, footprint, alg, digestid, digest);
    }

    public DSRecord(Name name, int dclass, long ttl, int digestid, DNSKEYRecord key) {
        this(name, dclass, ttl, key.getFootprint(), key.getAlgorithm(), digestid, DNSSEC.generateDSDigest(key, digestid));
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.footprint = in.readU16();
        this.alg = in.readU8();
        this.digestid = in.readU8();
        this.digest = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.footprint = st.getUInt16();
        this.alg = st.getUInt8();
        this.digestid = st.getUInt8();
        this.digest = st.getHex(true);
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.footprint);
        sb.append(" ");
        sb.append(this.alg);
        sb.append(" ");
        sb.append(this.digestid);
        if (this.digest != null) {
            sb.append(" ");
            sb.append(base16.toString(this.digest));
        }
        return sb.toString();
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public int getDigestID() {
        return this.digestid;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public int getFootprint() {
        return this.footprint;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.footprint);
        out.writeU8(this.alg);
        out.writeU8(this.digestid);
        if (this.digest != null) {
            out.writeByteArray(this.digest);
        }
    }

    @Deprecated
    public static class Digest {
        public static final int SHA1 = 1;
        public static final int SHA256 = 2;
        public static final int GOST3411 = 3;
        public static final int SHA384 = 4;

        private Digest() {
        }
    }
}

