/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreAbstractCompoundQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.protostellar.search.v1.ConjunctionQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.List;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreConjunctionQuery
extends CoreAbstractCompoundQuery {
    public CoreConjunctionQuery(List<CoreSearchQuery> queries, @Nullable Double boost) {
        super(queries, boost);
        if (this.childQueries.isEmpty()) {
            throw InvalidArgumentException.fromMessage("Conjunction query has no child query");
        }
    }

    @Override
    protected void injectParams(ObjectNode input) {
        ArrayNode conjuncts = Mapper.createArrayNode();
        for (CoreSearchQuery childQuery : this.childQueries) {
            ObjectNode childJson = Mapper.createObjectNode();
            childQuery.injectParamsAndBoost(childJson);
            conjuncts.add(childJson);
        }
        input.set("conjuncts", conjuncts);
    }

    @Override
    public Query asProtostellar() {
        ConjunctionQuery.Builder query = ConjunctionQuery.newBuilder().addAllQueries(this.childQueries.stream().map(CoreSearchQuery::asProtostellar).collect(Collectors.toList()));
        if (this.boost != null) {
            query.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setConjunctionQuery(query).build();
    }
}

