/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.util.HashedWheelTimer;
import com.couchbase.client.core.deps.io.netty.util.Timeout;
import com.couchbase.client.core.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.couchbase.client.core.env.TimerConfig;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@Stability.Internal
public class Timer {
    private final List<HashedWheelTimer> wheelTimers;
    private final AtomicLong currentTimer = new AtomicLong();
    private volatile boolean stopped = false;
    private final AtomicLong outstandingForRetry = new AtomicLong(0L);
    private final long maxNumRequestsInRetry;

    public static Timer create(long maxNumRequestsInRetry, TimerConfig timerConfig) {
        return new Timer(maxNumRequestsInRetry, timerConfig);
    }

    public static Timer createAndStart(long maxNumRequestsInRetry) {
        Timer timer = Timer.create(maxNumRequestsInRetry, TimerConfig.create());
        timer.start();
        return timer;
    }

    public static Timer createAndStart(long maxNumRequestsInRetry, TimerConfig timerConfig) {
        Timer timer = Timer.create(maxNumRequestsInRetry, timerConfig);
        timer.start();
        return timer;
    }

    private Timer(long maxNumRequestsInRetry, TimerConfig timerConfig) {
        this.maxNumRequestsInRetry = maxNumRequestsInRetry;
        this.wheelTimers = new ArrayList<HashedWheelTimer>();
        for (int i = 0; i < timerConfig.numTimers(); ++i) {
            HashedWheelTimer wheelTimer = new HashedWheelTimer(new DefaultThreadFactory("cb-timer" + (timerConfig.numTimers() == 1 ? "" : "-" + i), true), timerConfig.tickDuration().toMillis(), TimeUnit.MILLISECONDS, timerConfig.numBuckets());
            this.wheelTimers.add(wheelTimer);
        }
    }

    public void scheduleForRetry(Core core, Request<? extends Response> request, Duration runAfter) {
        if (this.stopped) {
            request.cancel(CancellationReason.SHUTDOWN);
            return;
        }
        if (this.outstandingForRetry.get() >= this.maxNumRequestsInRetry) {
            request.cancel(CancellationReason.TOO_MANY_REQUESTS_IN_RETRY);
            return;
        }
        this.schedule(() -> {
            if (!request.completed()) {
                core.send(request, false);
            }
        }, runAfter);
    }

    public Timeout schedule(Runnable callback, Duration runAfter) {
        return this.schedule(callback, runAfter, false);
    }

    public Timeout schedule(Runnable callback, Duration runAfter, boolean respectMax) {
        if (this.stopped) {
            return null;
        }
        if (this.outstandingForRetry.incrementAndGet() >= this.maxNumRequestsInRetry && respectMax) {
            this.outstandingForRetry.getAndDecrement();
            return null;
        }
        return this.timer().newTimeout(timeout -> {
            this.outstandingForRetry.decrementAndGet();
            callback.run();
        }, runAfter.toNanos(), TimeUnit.NANOSECONDS);
    }

    private HashedWheelTimer timer() {
        return this.wheelTimers.get((int)(this.currentTimer.getAndIncrement() % (long)this.wheelTimers.size()));
    }

    public void register(Request<Response> request) {
        if (this.stopped) {
            request.cancel(CancellationReason.SHUTDOWN);
            return;
        }
        Timeout registration = this.timer().newTimeout(timeout -> request.cancel(CancellationReason.TIMEOUT), request.timeout().toNanos(), TimeUnit.NANOSECONDS);
        request.timeoutRegistration(registration);
    }

    public void start() {
        this.wheelTimers.forEach(HashedWheelTimer::start);
    }

    public void stop() {
        this.stopped = true;
        this.wheelTimers.forEach(HashedWheelTimer::stop);
    }

    public long outstandingForRetry() {
        return this.outstandingForRetry.get();
    }

    public String toString() {
        return "Timer{wheelTimer=" + this.wheelTimers + ", stopped=" + this.stopped + ", outstandingForRetry=" + this.outstandingForRetry + ", maxNumRequestsInRetry=" + this.maxNumRequestsInRetry + '}';
    }
}

