/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.couchbase.client.core.deps.com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class HttpServerMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named("http-server-request-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpServerMetrics.class.getName());
    private final LongUpDownCounter activeRequests;
    private final DoubleHistogram duration;
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.upDownCounterBuilder("http.server.active_requests").setUnit("requests").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.duration = meter.histogramBuilder("http.server.duration").setUnit("ms").setDescription("The duration of the inbound HTTP request").build();
        this.requestSize = meter.histogramBuilder("http.server.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs().build();
        this.responseSize = meter.histogramBuilder("http.server.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs().build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        this.activeRequests.add(1L, TemporaryMetricsView.applyActiveRequestsView(startAttributes), context);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseLength;
        State state = context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        this.activeRequests.add(-1L, TemporaryMetricsView.applyActiveRequestsView(state.startAttributes()), context);
        Attributes durationAndSizeAttributes = TemporaryMetricsView.applyServerDurationAndSizeView(state.startAttributes(), endAttributes);
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, durationAndSizeAttributes, context);
        Long requestLength = HttpServerMetrics.getAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, endAttributes, state.startAttributes());
        if (requestLength != null) {
            this.requestSize.record(requestLength, durationAndSizeAttributes);
        }
        if ((responseLength = HttpServerMetrics.getAttribute(SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, endAttributes, state.startAttributes())) != null) {
            this.responseSize.record(responseLength, durationAndSizeAttributes);
        }
    }

    @Nullable
    private static <T> T getAttribute(AttributeKey<T> key, Attributes ... attributesList) {
        for (Attributes attributes : attributesList) {
            T value = attributes.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

