/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.manager;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCreateBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreStorageBackend;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.protostellar.admin.bucket.v1.BucketType;
import com.couchbase.client.protostellar.admin.bucket.v1.CompressionMode;
import com.couchbase.client.protostellar.admin.bucket.v1.ConflictResolutionType;
import com.couchbase.client.protostellar.admin.bucket.v1.CreateBucketRequest;
import com.couchbase.client.protostellar.admin.bucket.v1.DeleteBucketRequest;
import com.couchbase.client.protostellar.admin.bucket.v1.EvictionMode;
import com.couchbase.client.protostellar.admin.bucket.v1.ListBucketsRequest;
import com.couchbase.client.protostellar.admin.bucket.v1.StorageBackend;
import com.couchbase.client.protostellar.admin.bucket.v1.UpdateBucketRequest;
import com.couchbase.client.protostellar.kv.v1.DurabilityLevel;
import java.time.Duration;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarCoreBucketManagerRequests {
    private ProtostellarCoreBucketManagerRequests() {
    }

    public static ProtostellarRequest<CreateBucketRequest> createBucketRequest(CoreProtostellar core, CoreBucketSettings settings, @Nullable CoreCreateBucketSettings createSpecificSettings, CoreCommonOptions opts) {
        CreateBucketRequest.Builder request = CreateBucketRequest.newBuilder().setBucketName(settings.name()).setRamQuotaBytes(settings.ramQuotaMB() * 1024L * 1024L);
        if (settings.bucketType() != null) {
            switch (settings.bucketType()) {
                case COUCHBASE: {
                    request.setBucketType(BucketType.BUCKET_TYPE_COUCHBASE);
                    break;
                }
                case EPHEMERAL: {
                    request.setBucketType(BucketType.BUCKET_TYPE_EPHEMERAL);
                    break;
                }
                case MEMCACHED: {
                    request.setBucketType(BucketType.BUCKET_TYPE_MEMCACHED);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown bucket type");
                }
            }
        }
        if (settings.flushEnabled() != null) {
            request.setFlushEnabled(settings.flushEnabled());
        }
        if (settings.numReplicas() != null) {
            request.setNumReplicas(settings.numReplicas());
        }
        if (settings.replicaIndexes() != null) {
            request.setReplicaIndexes(settings.replicaIndexes());
        }
        if (settings.evictionPolicy() != null) {
            switch (settings.evictionPolicy()) {
                case FULL: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_FULL);
                    break;
                }
                case VALUE_ONLY: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_VALUE_ONLY);
                    break;
                }
                case NOT_RECENTLY_USED: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_NOT_RECENTLY_USED);
                    break;
                }
                case NO_EVICTION: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_NONE);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown eviction policy");
                }
            }
        }
        if (settings.maxExpiry() != null) {
            request.setMaxExpirySecs((int)settings.maxExpiry().toMillis() / 1000);
        }
        if (settings.compressionMode() != null) {
            switch (settings.compressionMode()) {
                case OFF: {
                    request.setCompressionMode(CompressionMode.COMPRESSION_MODE_OFF);
                    break;
                }
                case PASSIVE: {
                    request.setCompressionMode(CompressionMode.COMPRESSION_MODE_PASSIVE);
                    break;
                }
                case ACTIVE: {
                    request.setCompressionMode(CompressionMode.COMPRESSION_MODE_ACTIVE);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown compression mode");
                }
            }
        }
        if (settings.minimumDurabilityLevel() != null) {
            switch (settings.minimumDurabilityLevel()) {
                case NONE: {
                    break;
                }
                case MAJORITY: {
                    request.setMinimumDurabilityLevel(DurabilityLevel.DURABILITY_LEVEL_MAJORITY);
                    break;
                }
                case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                    request.setMinimumDurabilityLevel(DurabilityLevel.DURABILITY_LEVEL_MAJORITY_AND_PERSIST_TO_ACTIVE);
                    break;
                }
                case PERSIST_TO_MAJORITY: {
                    request.setMinimumDurabilityLevel(DurabilityLevel.DURABILITY_LEVEL_PERSIST_TO_MAJORITY);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown durability level");
                }
            }
        }
        if (settings.storageBackend() != null) {
            if (settings.storageBackend() == CoreStorageBackend.COUCHSTORE) {
                request.setStorageBackend(StorageBackend.STORAGE_BACKEND_COUCHSTORE);
            } else if (settings.storageBackend() == CoreStorageBackend.MAGMA) {
                request.setStorageBackend(StorageBackend.STORAGE_BACKEND_MAGMA);
            } else {
                throw InvalidArgumentException.fromMessage("Unknown storage backend");
            }
        }
        if (createSpecificSettings != null && createSpecificSettings.conflictResolutionType() != null) {
            switch (createSpecificSettings.conflictResolutionType()) {
                case TIMESTAMP: {
                    request.setConflictResolutionType(ConflictResolutionType.CONFLICT_RESOLUTION_TYPE_TIMESTAMP);
                    break;
                }
                case SEQUENCE_NUMBER: {
                    request.setConflictResolutionType(ConflictResolutionType.CONFLICT_RESOLUTION_TYPE_SEQUENCE_NUMBER);
                    break;
                }
                case CUSTOM: {
                    request.setConflictResolutionType(ConflictResolutionType.CONFLICT_RESOLUTION_TYPE_CUSTOM);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown conflict resolution type");
                }
            }
        }
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        return new ProtostellarRequest<CreateBucketRequest>(request.build(), core, ServiceType.MANAGER, "manager_buckets_create_bucket", CoreProtostellarUtil.createSpan(core, "manager_buckets_create_bucket", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L, null);
    }

    public static ProtostellarRequest<UpdateBucketRequest> updateBucketRequest(CoreProtostellar core, CoreBucketSettings settings, CoreCommonOptions opts) {
        UpdateBucketRequest.Builder request = UpdateBucketRequest.newBuilder().setBucketName(settings.name()).setRamQuotaBytes(settings.ramQuotaMB() * 1024L * 1024L);
        if (settings.flushEnabled() != null) {
            request.setFlushEnabled(settings.flushEnabled());
        }
        if (settings.numReplicas() != null) {
            request.setNumReplicas(settings.numReplicas());
        }
        if (settings.replicaIndexes() != null) {
            request.setReplicaIndexes(settings.replicaIndexes());
        }
        if (settings.evictionPolicy() != null) {
            switch (settings.evictionPolicy()) {
                case FULL: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_FULL);
                    break;
                }
                case VALUE_ONLY: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_VALUE_ONLY);
                    break;
                }
                case NOT_RECENTLY_USED: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_NOT_RECENTLY_USED);
                    break;
                }
                case NO_EVICTION: {
                    request.setEvictionMode(EvictionMode.EVICTION_MODE_NONE);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown eviction policy");
                }
            }
        }
        if (settings.maxExpiry() != null) {
            request.setMaxExpirySecs((int)settings.maxExpiry().getSeconds());
        }
        if (settings.compressionMode() != null) {
            switch (settings.compressionMode()) {
                case OFF: {
                    request.setCompressionMode(CompressionMode.COMPRESSION_MODE_OFF);
                    break;
                }
                case PASSIVE: {
                    request.setCompressionMode(CompressionMode.COMPRESSION_MODE_PASSIVE);
                    break;
                }
                case ACTIVE: {
                    request.setCompressionMode(CompressionMode.COMPRESSION_MODE_ACTIVE);
                    break;
                }
                default: {
                    throw InvalidArgumentException.fromMessage("Unknown compression mode");
                }
            }
        }
        if (settings.minimumDurabilityLevel() != null) {
            request.setMinimumDurabilityLevel(CoreProtostellarUtil.convert(settings.minimumDurabilityLevel()));
        }
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        return new ProtostellarRequest<UpdateBucketRequest>(request.build(), core, ServiceType.MANAGER, "manager_buckets_update_bucket", CoreProtostellarUtil.createSpan(core, "manager_buckets_update_bucket", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L, null);
    }

    public static ProtostellarRequest<DeleteBucketRequest> deleteBucketRequest(CoreProtostellar core, String bucketName, CoreCommonOptions opts) {
        DeleteBucketRequest request = DeleteBucketRequest.newBuilder().setBucketName(bucketName).build();
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        return new ProtostellarRequest<DeleteBucketRequest>(request, core, ServiceType.MANAGER, "manager_buckets_drop_bucket", CoreProtostellarUtil.createSpan(core, "manager_buckets_drop_bucket", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L, null);
    }

    public static ProtostellarRequest<ListBucketsRequest> listBucketsRequest(CoreProtostellar core, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        return new ProtostellarRequest<ListBucketsRequest>(ListBucketsRequest.getDefaultInstance(), core, ServiceType.MANAGER, "manager_buckets_get_all_buckets", CoreProtostellarUtil.createSpan(core, "manager_buckets_get_all_buckets", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L, null);
    }
}

