/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.search;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.HttpRequest;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.search.SearchChunkHeader;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.core.msg.search.SearchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class SearchRequest
extends BaseRequest<SearchResponse>
implements HttpRequest<SearchChunkHeader, SearchChunkRow, SearchChunkTrailer, SearchResponse> {
    private final String indexName;
    private final byte[] content;
    private final Authenticator authenticator;
    private final CoreBucketAndScope scope;

    public SearchRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Authenticator authenticator, String indexName, byte[] content, RequestSpan span, @Nullable CoreBucketAndScope scope) {
        super(timeout, ctx, retryStrategy, span);
        this.indexName = indexName;
        this.content = content;
        this.authenticator = authenticator;
        this.scope = scope;
        if (span != null && !CbTracing.isInternalSpan(span)) {
            span.attribute("db.couchbase.service", "search");
            span.attribute("db.operation", indexName);
        }
    }

    @Override
    public FullHttpRequest encode() {
        ByteBuf c = Unpooled.wrappedBuffer(this.content);
        String uri = this.scope == null ? CoreHttpPath.formatPath("/api/index/{}/query", this.indexName) : CoreHttpPath.formatPath("/api/bucket/{}/scope/{}/index/{}/query", this.scope.bucketName(), this.scope.scopeName(), this.indexName);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri, c);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)c.readableBytes());
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.SEARCH;
    }

    @Override
    public SearchResponse decode(ResponseStatus status, SearchChunkHeader header, Flux<SearchChunkRow> rows, Mono<SearchChunkTrailer> trailer) {
        return new SearchResponse(status, header, rows, trailer);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("indexName", RedactableArgument.redactMeta(this.indexName));
        return ctx;
    }

    @Override
    public String name() {
        return "search";
    }
}

