/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.jctools.queues.atomic;

import com.couchbase.client.core.deps.org.jctools.queues.MessagePassingQueue;
import com.couchbase.client.core.deps.org.jctools.queues.atomic.AtomicQueueUtil;
import com.couchbase.client.core.deps.org.jctools.queues.atomic.SpscAtomicArrayQueueL3Pad;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscAtomicArrayQueue<E>
extends SpscAtomicArrayQueueL3Pad<E> {
    public SpscAtomicArrayQueue(int capacity) {
        super(Math.max(capacity, 4));
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        if (producerIndex >= this.producerLimit && !this.offerSlowPath(buffer, mask, producerIndex)) {
            return false;
        }
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
        AtomicQueueUtil.soRefElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    private boolean offerSlowPath(AtomicReferenceArray<E> buffer, int mask, long producerIndex) {
        int lookAheadStep = this.lookAheadStep;
        if (null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(producerIndex + (long)lookAheadStep, mask))) {
            this.producerLimit = producerIndex + (long)lookAheadStep;
        } else {
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
            if (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray buffer = this.buffer;
        long consumerIndex = this.lpConsumerIndex();
        int offset = AtomicQueueUtil.calcCircularRefElementOffset(consumerIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
        if (null == e) {
            return null;
        }
        AtomicQueueUtil.soRefElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return e;
    }

    @Override
    public E peek() {
        return AtomicQueueUtil.lvRefElement(this.buffer, AtomicQueueUtil.calcCircularRefElementOffset(this.lpConsumerIndex(), this.mask));
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = consumerIndex + (long)i;
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
            Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
            if (null == e) {
                return i;
            }
            AtomicQueueUtil.soRefElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        for (int i = 0; i < limit; ++i) {
            long index = producerIndex + (long)i;
            int lookAheadElementOffset = AtomicQueueUtil.calcCircularRefElementOffset(index + (long)lookAheadStep, mask);
            if (null == AtomicQueueUtil.lvRefElement(buffer, lookAheadElementOffset)) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                for (int j = 0; j < lookAheadLimit; ++j) {
                    int offset = AtomicQueueUtil.calcCircularRefElementOffset(index + (long)j, mask);
                    AtomicQueueUtil.soRefElement(buffer, offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                }
                i += lookAheadLimit - 1;
                continue;
            }
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(index, mask);
            if (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
                return i;
            }
            AtomicQueueUtil.soRefElement(buffer, offset, s.get());
            this.soProducerIndex(index + 1L);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (null == w) {
            throw new IllegalArgumentException("wait is null");
        }
        if (null == exit) {
            throw new IllegalArgumentException("exit condition is null");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.lpConsumerIndex();
        int counter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                int offset = AtomicQueueUtil.calcCircularRefElementOffset(consumerIndex, mask);
                Object e = AtomicQueueUtil.lvRefElement(buffer, offset);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                AtomicQueueUtil.soRefElement(buffer, offset, null);
                this.soConsumerIndex(++consumerIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        if (null == w) {
            throw new IllegalArgumentException("waiter is null");
        }
        if (null == e) {
            throw new IllegalArgumentException("exit condition is null");
        }
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.lpProducerIndex();
        int counter = 0;
        while (e.keepRunning()) {
            int lookAheadElementOffset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex + (long)lookAheadStep, mask);
            if (null == AtomicQueueUtil.lvRefElement(buffer, lookAheadElementOffset)) {
                for (int j = 0; j < lookAheadStep; ++j) {
                    int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
                    AtomicQueueUtil.soRefElement(buffer, offset, s.get());
                    this.soProducerIndex(++producerIndex);
                }
                continue;
            }
            int offset = AtomicQueueUtil.calcCircularRefElementOffset(producerIndex, mask);
            if (null != AtomicQueueUtil.lvRefElement(buffer, offset)) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            AtomicQueueUtil.soRefElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

