/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6;

import com.couchbase.client.core.deps.io.grpc.CallOptions;
import com.couchbase.client.core.deps.io.grpc.Channel;
import com.couchbase.client.core.deps.io.grpc.ClientCall;
import com.couchbase.client.core.deps.io.grpc.ClientInterceptor;
import com.couchbase.client.core.deps.io.grpc.ForwardingClientCall;
import com.couchbase.client.core.deps.io.grpc.ForwardingClientCallListener;
import com.couchbase.client.core.deps.io.grpc.Grpc;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.MethodDescriptor;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcHelper;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.MetadataSetter;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TracingClientInterceptor
implements ClientInterceptor {
    private static final AtomicLongFieldUpdater<TracingClientCall> MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingClientCall.class, "messageId");
    private final Instrumenter<GrpcRequest, Status> instrumenter;
    private final ContextPropagators propagators;

    TracingClientInterceptor(Instrumenter<GrpcRequest, Status> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public <REQUEST, RESPONSE> ClientCall<REQUEST, RESPONSE> interceptCall(MethodDescriptor<REQUEST, RESPONSE> method, CallOptions callOptions, Channel next) {
        ClientCall<REQUEST, RESPONSE> result;
        GrpcRequest request = new GrpcRequest(method, null, null, next.authority());
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return next.newCall(method, callOptions);
        }
        Context context = this.instrumenter.start(parentContext, request);
        try (Scope ignored = context.makeCurrent();){
            try {
                result = next.newCall(method, callOptions);
            }
            catch (Throwable e) {
                this.instrumenter.end(context, request, Status.UNKNOWN, e);
                throw e;
            }
        }
        request.setPeerSocketAddress(result.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
        return new TracingClientCall<REQUEST, RESPONSE>(result, parentContext, context, request);
    }

    final class TracingClientCall<REQUEST, RESPONSE>
    extends ForwardingClientCall.SimpleForwardingClientCall<REQUEST, RESPONSE> {
        private final Context parentContext;
        private final Context context;
        private final GrpcRequest request;
        volatile long messageId;

        TracingClientCall(ClientCall<REQUEST, RESPONSE> delegate, Context parentContext, Context context, GrpcRequest request) {
            super(delegate);
            this.parentContext = parentContext;
            this.context = context;
            this.request = request;
        }

        @Override
        public void start(ClientCall.Listener<RESPONSE> responseListener, Metadata headers) {
            TracingClientInterceptor.this.propagators.getTextMapPropagator().inject(this.context, headers, MetadataSetter.INSTANCE);
            this.request.setMetadata(headers);
            try (Scope ignored = this.context.makeCurrent();){
                super.start(new TracingClientCallListener(responseListener, this.parentContext, this.context, this.request), headers);
            }
            catch (Throwable e) {
                TracingClientInterceptor.this.instrumenter.end(this.context, this.request, Status.UNKNOWN, e);
                throw e;
            }
        }

        @Override
        public void sendMessage(REQUEST message) {
            try (Scope ignored = this.context.makeCurrent();){
                super.sendMessage(message);
            }
            catch (Throwable e) {
                TracingClientInterceptor.this.instrumenter.end(this.context, this.request, Status.UNKNOWN, e);
                throw e;
            }
            Span span = Span.fromContext(this.context);
            Attributes attributes = Attributes.of(GrpcHelper.MESSAGE_TYPE, "SENT", GrpcHelper.MESSAGE_ID, MESSAGE_ID_UPDATER.incrementAndGet(this));
            span.addEvent("message", attributes);
        }

        final class TracingClientCallListener
        extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RESPONSE> {
            private final Context parentContext;
            private final Context context;
            private final GrpcRequest request;

            TracingClientCallListener(ClientCall.Listener<RESPONSE> delegate, Context parentContext, Context context, GrpcRequest request) {
                super(delegate);
                this.parentContext = parentContext;
                this.context = context;
                this.request = request;
            }

            @Override
            public void onMessage(RESPONSE message) {
                Span span = Span.fromContext(this.context);
                Attributes attributes = Attributes.of(GrpcHelper.MESSAGE_TYPE, "RECEIVED", GrpcHelper.MESSAGE_ID, MESSAGE_ID_UPDATER.incrementAndGet(TracingClientCall.this));
                span.addEvent("message", attributes);
                try (Scope ignored = this.context.makeCurrent();){
                    this.delegate().onMessage(message);
                }
            }

            @Override
            public void onClose(Status status, Metadata trailers) {
                TracingClientInterceptor.this.instrumenter.end(this.context, this.request, status, status.getCause());
                try (Scope ignored = this.parentContext.makeCurrent();){
                    this.delegate().onClose(status, trailers);
                }
            }

            @Override
            public void onReady() {
                try (Scope ignored = this.context.makeCurrent();){
                    this.delegate().onReady();
                }
            }
        }
    }
}

