/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6;

import com.couchbase.client.core.deps.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcAttributesExtractor;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequestGetter;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRpcAttributesGetter;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcSpanNameExtractor;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcSpanStatusExtractor;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.internal.GrpcNetClientAttributesGetter;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.internal.GrpcNetServerAttributesGetter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcServerMetrics;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class GrpcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.grpc-1.6";
    private final OpenTelemetry openTelemetry;
    @Nullable
    private String peerService;
    @Nullable
    private Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> clientSpanNameExtractorTransformer;
    @Nullable
    private Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> serverSpanNameExtractorTransformer;
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private final List<AttributesExtractor<? super GrpcRequest, ? super Status>> additionalClientExtractors = new ArrayList<AttributesExtractor<? super GrpcRequest, ? super Status>>();
    private boolean captureExperimentalSpanAttributes;

    GrpcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder addClientAttributeExtractor(AttributesExtractor<? super GrpcRequest, ? super Status> attributesExtractor) {
        this.additionalClientExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setClientSpanNameExtractor(Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> clientSpanNameExtractor) {
        this.clientSpanNameExtractorTransformer = clientSpanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setServerSpanNameExtractor(Function<SpanNameExtractor<GrpcRequest>, ? extends SpanNameExtractor<? super GrpcRequest>> serverSpanNameExtractor) {
        this.serverSpanNameExtractorTransformer = serverSpanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setPeerService(String peerService) {
        this.peerService = peerService;
        return this;
    }

    @CanIgnoreReturnValue
    public GrpcTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    public GrpcTelemetry build() {
        GrpcSpanNameExtractor originalSpanNameExtractor;
        SpanNameExtractor<GrpcRequest> clientSpanNameExtractor = originalSpanNameExtractor = new GrpcSpanNameExtractor();
        if (this.clientSpanNameExtractorTransformer != null) {
            clientSpanNameExtractor = this.clientSpanNameExtractorTransformer.apply(originalSpanNameExtractor);
        }
        SpanNameExtractor<GrpcRequest> serverSpanNameExtractor = originalSpanNameExtractor;
        if (this.serverSpanNameExtractorTransformer != null) {
            serverSpanNameExtractor = this.serverSpanNameExtractorTransformer.apply(originalSpanNameExtractor);
        }
        InstrumenterBuilder clientInstrumenterBuilder = Instrumenter.builder(this.openTelemetry, INSTRUMENTATION_NAME, clientSpanNameExtractor);
        InstrumenterBuilder serverInstrumenterBuilder = Instrumenter.builder(this.openTelemetry, INSTRUMENTATION_NAME, serverSpanNameExtractor);
        Stream.of(clientInstrumenterBuilder, serverInstrumenterBuilder).forEach(instrumenter -> instrumenter.setSpanStatusExtractor(new GrpcSpanStatusExtractor()).addAttributesExtractor(new GrpcAttributesExtractor()).addAttributesExtractors(this.additionalExtractors));
        GrpcNetClientAttributesGetter netClientAttributesGetter = new GrpcNetClientAttributesGetter();
        GrpcRpcAttributesGetter rpcAttributesGetter = GrpcRpcAttributesGetter.INSTANCE;
        clientInstrumenterBuilder.addAttributesExtractor(RpcClientAttributesExtractor.create(rpcAttributesGetter)).addAttributesExtractor(NetClientAttributesExtractor.create(netClientAttributesGetter)).addAttributesExtractors(this.additionalClientExtractors).addOperationMetrics(RpcClientMetrics.get());
        serverInstrumenterBuilder.addAttributesExtractor(RpcServerAttributesExtractor.create(rpcAttributesGetter)).addAttributesExtractor(NetServerAttributesExtractor.create(new GrpcNetServerAttributesGetter())).addOperationMetrics(RpcServerMetrics.get());
        if (this.peerService != null) {
            clientInstrumenterBuilder.addAttributesExtractor(AttributesExtractor.constant(SemanticAttributes.PEER_SERVICE, this.peerService));
        }
        return new GrpcTelemetry(serverInstrumenterBuilder.buildServerInstrumenter(GrpcRequestGetter.INSTANCE), clientInstrumenterBuilder.buildInstrumenter(SpanKindExtractor.alwaysClient()), this.openTelemetry.getPropagators(), this.captureExperimentalSpanAttributes);
    }
}

