/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import java.util.Comparator;
import java.util.Objects;
import reactor.util.annotation.NonNull;

@Stability.Internal
public class ConfigVersion
implements Comparable<ConfigVersion> {
    private static final Comparator<ConfigVersion> naturalOrder = Comparator.comparing(ConfigVersion::epoch).thenComparing(ConfigVersion::rev);
    private final long epoch;
    private final long rev;

    public ConfigVersion(long epoch, long rev) {
        this.epoch = epoch;
        this.rev = rev;
    }

    public long epoch() {
        return this.epoch;
    }

    public long rev() {
        return this.rev;
    }

    public String toString() {
        return this.epoch + "." + this.rev;
    }

    @Override
    public int compareTo(@NonNull ConfigVersion o) {
        return naturalOrder.compare(this, o);
    }

    public boolean isLessThanOrEqualTo(ConfigVersion other) {
        return this.compareTo(other) < 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigVersion that = (ConfigVersion)o;
        return this.epoch == that.epoch && this.rev == that.rev;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.rev);
    }
}

