/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class RetryAction {
    private static final RetryAction NO_RETRY = new RetryAction(Optional.empty(), Function.identity());
    private final Optional<Duration> duration;
    private final Function<Throwable, Throwable> exceptionTranslator;

    private RetryAction(Optional<Duration> duration, Function<Throwable, Throwable> exceptionTranslator) {
        this.duration = Objects.requireNonNull(duration);
        this.exceptionTranslator = Objects.requireNonNull(exceptionTranslator);
    }

    public static RetryAction withDuration(Duration duration) {
        return new RetryAction(Optional.of(duration), Function.identity());
    }

    public static RetryAction noRetry() {
        return NO_RETRY;
    }

    @Stability.Volatile
    public static RetryAction noRetry(Function<Throwable, Throwable> exceptionTranslator) {
        return new RetryAction(Optional.empty(), exceptionTranslator);
    }

    public Optional<Duration> duration() {
        return this.duration;
    }

    public Function<Throwable, Throwable> exceptionTranslator() {
        return this.exceptionTranslator;
    }
}

