/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.manager;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.manager.CoreCollectionManager;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessors;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.manager.CoreProtostellarCollectionManagerRequests;
import com.couchbase.client.core.protostellar.manager.CoreProtostellarCollectionManagerResponses;
import com.couchbase.client.protostellar.admin.collection.v1.CollectionAdminServiceGrpc;
import com.couchbase.client.protostellar.admin.collection.v1.CreateCollectionRequest;
import com.couchbase.client.protostellar.admin.collection.v1.CreateScopeRequest;
import com.couchbase.client.protostellar.admin.collection.v1.DeleteCollectionRequest;
import com.couchbase.client.protostellar.admin.collection.v1.DeleteScopeRequest;
import com.couchbase.client.protostellar.admin.collection.v1.ListCollectionsRequest;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public final class ProtostellarCoreCollectionManagerOps
implements CoreCollectionManager {
    private final CoreProtostellar core;
    private final String bucketName;

    public ProtostellarCoreCollectionManagerOps(CoreProtostellar core, String bucketName) {
        this.core = Objects.requireNonNull(core);
        this.bucketName = Objects.requireNonNull(bucketName);
    }

    @Override
    public CompletableFuture<Void> createCollection(String scopeName, String collectionName, Duration maxTTL, CoreCommonOptions options) {
        ProtostellarRequest<CreateCollectionRequest> request = CoreProtostellarCollectionManagerRequests.createCollectionRequest(this.core, this.bucketName, scopeName, collectionName, maxTTL, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub)endpoint.collectionAdminStub().withDeadline(request.deadline())).createCollection((CreateCollectionRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<Void> createScope(String scopeName, CoreCommonOptions options) {
        ProtostellarRequest<CreateScopeRequest> request = CoreProtostellarCollectionManagerRequests.createScopeRequest(this.core, this.bucketName, scopeName, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub)endpoint.collectionAdminStub().withDeadline(request.deadline())).createScope((CreateScopeRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<Void> dropCollection(String scopeName, String collectionName, CoreCommonOptions options) {
        ProtostellarRequest<DeleteCollectionRequest> request = CoreProtostellarCollectionManagerRequests.deleteCollectionRequest(this.core, this.bucketName, scopeName, collectionName, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub)endpoint.collectionAdminStub().withDeadline(request.deadline())).deleteCollection((DeleteCollectionRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<Void> dropScope(String scopeName, CoreCommonOptions options) {
        ProtostellarRequest<DeleteScopeRequest> request = CoreProtostellarCollectionManagerRequests.deleteScopeRequest(this.core, this.bucketName, scopeName, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub)endpoint.collectionAdminStub().withDeadline(request.deadline())).deleteScope((DeleteScopeRequest)request.request()), response -> null).thenApply(obj -> null);
    }

    @Override
    public CompletableFuture<CollectionsManifest> getAllScopes(CoreCommonOptions options) {
        ProtostellarRequest<ListCollectionsRequest> request = CoreProtostellarCollectionManagerRequests.listCollectionsRequest(this.core, this.bucketName, options);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub)endpoint.collectionAdminStub().withDeadline(request.deadline())).listCollections((ListCollectionsRequest)request.request()), response -> CoreProtostellarCollectionManagerResponses.convertResponse(response)).toFuture();
    }
}

