/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreExistsResult;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocGetCommand;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateCommand;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.kv.CoreScanType;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessors;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.kv.CoreProtostellarKeyValueRequests;
import com.couchbase.client.core.protostellar.kv.CoreProtostellarKeyValueResponses;
import com.couchbase.client.protostellar.kv.v1.ExistsRequest;
import com.couchbase.client.protostellar.kv.v1.GetAndLockRequest;
import com.couchbase.client.protostellar.kv.v1.GetAndTouchRequest;
import com.couchbase.client.protostellar.kv.v1.GetRequest;
import com.couchbase.client.protostellar.kv.v1.InsertRequest;
import com.couchbase.client.protostellar.kv.v1.KvServiceGrpc;
import com.couchbase.client.protostellar.kv.v1.LookupInRequest;
import com.couchbase.client.protostellar.kv.v1.MutateInRequest;
import com.couchbase.client.protostellar.kv.v1.RemoveRequest;
import com.couchbase.client.protostellar.kv.v1.ReplaceRequest;
import com.couchbase.client.protostellar.kv.v1.TouchRequest;
import com.couchbase.client.protostellar.kv.v1.UnlockRequest;
import com.couchbase.client.protostellar.kv.v1.UpsertRequest;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public final class ProtostellarCoreKvOps
implements CoreKvOps {
    private final CoreProtostellar core;
    private final CoreKeyspace keyspace;

    public ProtostellarCoreKvOps(CoreProtostellar core, CoreKeyspace keyspace) {
        this.core = Objects.requireNonNull(core);
        this.keyspace = Objects.requireNonNull(keyspace);
    }

    @Override
    public CoreGetResult getBlocking(CoreCommonOptions common, String key, List<String> projections, boolean withExpiry) {
        ProtostellarRequest<GetRequest> req = CoreProtostellarKeyValueRequests.getRequest(this.core, common, this.keyspace, key, projections, withExpiry);
        return CoreProtostellarAccessors.blocking(this.core, req, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(req.deadline())).get((GetRequest)req.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreGetResult> getAsync(CoreCommonOptions common, String key, List<String> projections, boolean withExpiry) {
        ProtostellarRequest<GetRequest> req = CoreProtostellarKeyValueRequests.getRequest(this.core, common, this.keyspace, key, projections, withExpiry);
        return CoreProtostellarAccessors.async(this.core, req, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(req.deadline())).get((GetRequest)req.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public Mono<CoreGetResult> getReactive(CoreCommonOptions common, String key, List<String> projections, boolean withExpiry) {
        ProtostellarRequest<GetRequest> req = CoreProtostellarKeyValueRequests.getRequest(this.core, common, this.keyspace, key, projections, withExpiry);
        return CoreProtostellarAccessors.reactive(this.core, req, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(req.deadline())).get((GetRequest)req.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreGetResult> getAndLockAsync(CoreCommonOptions common, String key, Duration lockTime) {
        ProtostellarRequest<GetAndLockRequest> req = CoreProtostellarKeyValueRequests.getAndLockRequest(this.core, common, this.keyspace, key, lockTime);
        return CoreProtostellarAccessors.async(this.core, req, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(req.deadline())).getAndLock((GetAndLockRequest)req.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreGetResult> getAndTouchAsync(CoreCommonOptions common, String key, CoreExpiry expiry) {
        ProtostellarRequest<GetAndTouchRequest> req = CoreProtostellarKeyValueRequests.getAndTouchRequest(this.core, common, this.keyspace, key, expiry);
        return CoreProtostellarAccessors.async(this.core, req, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(req.deadline())).getAndTouch((GetAndTouchRequest)req.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreMutationResult insertBlocking(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry) {
        ProtostellarRequest<InsertRequest> request = CoreProtostellarKeyValueRequests.insertRequest(this.core, this.keyspace, common, key, content, durability, expiry);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).insert((InsertRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> insertAsync(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry) {
        ProtostellarRequest<InsertRequest> request = CoreProtostellarKeyValueRequests.insertRequest(this.core, this.keyspace, common, key, content, durability, expiry);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).insert((InsertRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public Mono<CoreMutationResult> insertReactive(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry) {
        ProtostellarRequest<InsertRequest> request = CoreProtostellarKeyValueRequests.insertRequest(this.core, this.keyspace, common, key, content, durability, expiry);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).insert((InsertRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreMutationResult upsertBlocking(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry) {
        ProtostellarRequest<UpsertRequest> request = CoreProtostellarKeyValueRequests.upsertRequest(this.core, this.keyspace, common, key, content, durability, expiry, preserveExpiry);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).upsert((UpsertRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> upsertAsync(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry) {
        ProtostellarRequest<UpsertRequest> request = CoreProtostellarKeyValueRequests.upsertRequest(this.core, this.keyspace, common, key, content, durability, expiry, preserveExpiry);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).upsert((UpsertRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public Mono<CoreMutationResult> upsertReactive(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry) {
        ProtostellarRequest<UpsertRequest> request = CoreProtostellarKeyValueRequests.upsertRequest(this.core, this.keyspace, common, key, content, durability, expiry, preserveExpiry);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).upsert((UpsertRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreMutationResult replaceBlocking(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry) {
        ProtostellarRequest<ReplaceRequest> request = CoreProtostellarKeyValueRequests.replaceRequest(this.core, this.keyspace, common, key, content, cas, durability, expiry, preserveExpiry);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).replace((ReplaceRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> replaceAsync(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry) {
        ProtostellarRequest<ReplaceRequest> request = CoreProtostellarKeyValueRequests.replaceRequest(this.core, this.keyspace, common, key, content, cas, durability, expiry, preserveExpiry);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).replace((ReplaceRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public Mono<CoreMutationResult> replaceReactive(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry) {
        ProtostellarRequest<ReplaceRequest> request = CoreProtostellarKeyValueRequests.replaceRequest(this.core, this.keyspace, common, key, content, cas, durability, expiry, preserveExpiry);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).replace((ReplaceRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreMutationResult removeBlocking(CoreCommonOptions common, String key, long cas, CoreDurability durability) {
        ProtostellarRequest<RemoveRequest> request = CoreProtostellarKeyValueRequests.removeRequest(this.core, this.keyspace, common, key, cas, durability);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).remove((RemoveRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> removeAsync(CoreCommonOptions common, String key, long cas, CoreDurability durability) {
        ProtostellarRequest<RemoveRequest> request = CoreProtostellarKeyValueRequests.removeRequest(this.core, this.keyspace, common, key, cas, durability);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).remove((RemoveRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public Mono<CoreMutationResult> removeReactive(CoreCommonOptions common, String key, long cas, CoreDurability durability) {
        ProtostellarRequest<RemoveRequest> request = CoreProtostellarKeyValueRequests.removeRequest(this.core, this.keyspace, common, key, cas, durability);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).remove((RemoveRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreExistsResult existsBlocking(CoreCommonOptions common, String key) {
        ProtostellarRequest<ExistsRequest> request = CoreProtostellarKeyValueRequests.existsRequest(this.core, this.keyspace, common, key);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).exists((ExistsRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreExistsResult> existsAsync(CoreCommonOptions common, String key) {
        ProtostellarRequest<ExistsRequest> request = CoreProtostellarKeyValueRequests.existsRequest(this.core, this.keyspace, common, key);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).exists((ExistsRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public Mono<CoreExistsResult> existsReactive(CoreCommonOptions common, String key) {
        ProtostellarRequest<ExistsRequest> request = CoreProtostellarKeyValueRequests.existsRequest(this.core, this.keyspace, common, key);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).exists((ExistsRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<CoreMutationResult> touchAsync(CoreCommonOptions common, String key, CoreExpiry expiry) {
        ProtostellarRequest<TouchRequest> request = CoreProtostellarKeyValueRequests.touchRequest(this.core, this.keyspace, common, key, expiry);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).touch((TouchRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response));
    }

    @Override
    public CoreAsyncResponse<Void> unlockAsync(CoreCommonOptions common, String key, long cas) {
        ProtostellarRequest<UnlockRequest> request = CoreProtostellarKeyValueRequests.unlockRequest(this.core, this.keyspace, common, key, cas);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).unlock((UnlockRequest)request.request()), response -> null);
    }

    @Override
    public CoreSubdocGetResult subdocGetBlocking(CoreCommonOptions common, String key, List<CoreSubdocGetCommand> commands, boolean accessDeleted) {
        ProtostellarRequest<LookupInRequest> request = CoreProtostellarKeyValueRequests.lookupInRequest(this.core, this.keyspace, common, key, commands, accessDeleted);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).lookupIn((LookupInRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.core, request, this.keyspace, key, response, commands));
    }

    @Override
    public CoreAsyncResponse<CoreSubdocGetResult> subdocGetAsync(CoreCommonOptions common, String key, List<CoreSubdocGetCommand> commands, boolean accessDeleted) {
        ProtostellarRequest<LookupInRequest> request = CoreProtostellarKeyValueRequests.lookupInRequest(this.core, this.keyspace, common, key, commands, accessDeleted);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).lookupIn((LookupInRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.core, request, this.keyspace, key, response, commands));
    }

    @Override
    public Mono<CoreSubdocGetResult> subdocGetReactive(CoreCommonOptions common, String key, List<CoreSubdocGetCommand> commands, boolean accessDeleted) {
        ProtostellarRequest<LookupInRequest> request = CoreProtostellarKeyValueRequests.lookupInRequest(this.core, this.keyspace, common, key, commands, accessDeleted);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).lookupIn((LookupInRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.core, request, this.keyspace, key, response, commands));
    }

    @Override
    public Flux<CoreGetResult> getAllReplicasReactive(CoreCommonOptions common, String key) {
        throw ProtostellarCoreKvOps.unsupported();
    }

    @Override
    public Mono<CoreGetResult> getAnyReplicaReactive(CoreCommonOptions common, String key) {
        throw ProtostellarCoreKvOps.unsupported();
    }

    @Override
    public CoreSubdocMutateResult subdocMutateBlocking(CoreCommonOptions common, String key, Supplier<List<CoreSubdocMutateCommand>> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        List<CoreSubdocMutateCommand> specs = commands.get();
        ProtostellarRequest<MutateInRequest> request = CoreProtostellarKeyValueRequests.mutateInRequest(this.core, this.keyspace, common, key, specs, storeSemantics, cas, durability, expiry, preserveExpiry, accessDeleted, createAsDeleted);
        return CoreProtostellarAccessors.blocking(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceBlockingStub)endpoint.kvBlockingStub().withDeadline(request.deadline())).mutateIn((MutateInRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response, specs));
    }

    @Override
    public CoreAsyncResponse<CoreSubdocMutateResult> subdocMutateAsync(CoreCommonOptions common, String key, Supplier<List<CoreSubdocMutateCommand>> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        List<CoreSubdocMutateCommand> specs = commands.get();
        ProtostellarRequest<MutateInRequest> request = CoreProtostellarKeyValueRequests.mutateInRequest(this.core, this.keyspace, common, key, specs, storeSemantics, cas, durability, expiry, preserveExpiry, accessDeleted, createAsDeleted);
        return CoreProtostellarAccessors.async(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).mutateIn((MutateInRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response, specs));
    }

    @Override
    public Mono<CoreSubdocMutateResult> subdocMutateReactive(CoreCommonOptions common, String key, Supplier<List<CoreSubdocMutateCommand>> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        List<CoreSubdocMutateCommand> specs = commands.get();
        ProtostellarRequest<MutateInRequest> request = CoreProtostellarKeyValueRequests.mutateInRequest(this.core, this.keyspace, common, key, specs, storeSemantics, cas, durability, expiry, preserveExpiry, accessDeleted, createAsDeleted);
        return CoreProtostellarAccessors.reactive(this.core, request, endpoint -> ((KvServiceGrpc.KvServiceFutureStub)endpoint.kvStub().withDeadline(request.deadline())).mutateIn((MutateInRequest)request.request()), response -> CoreProtostellarKeyValueResponses.convertResponse(this.keyspace, key, response, specs));
    }

    @Override
    public Flux<CoreRangeScanItem> scanRequestReactive(CoreScanType scanType, CoreScanOptions options) {
        throw ProtostellarCoreKvOps.unsupported();
    }

    @Override
    public CompletableFuture<List<CoreRangeScanItem>> scanRequestAsync(CoreScanType scanType, CoreScanOptions options) {
        throw ProtostellarCoreKvOps.unsupported();
    }

    @Override
    public Stream<CoreRangeScanItem> scanRequestBlocking(CoreScanType scanType, CoreScanOptions options) {
        throw ProtostellarCoreKvOps.unsupported();
    }

    private static RuntimeException unsupported() {
        return new UnsupportedOperationException("Not currently supported");
    }
}

