/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.metrics.NoopMeter;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import reactor.util.annotation.Nullable;

public class RequestContext
extends CoreContext {
    private volatile long dispatchLatency;
    private final AtomicLong totalDispatchLatency = new AtomicLong(0L);
    private volatile long serverLatency;
    private final AtomicLong totalServerLatency = new AtomicLong(0L);
    private volatile long logicallyCompletedAt;
    private volatile long encodeLatency;
    private volatile String lastChannelId;
    private final Request<? extends Response> request;
    private volatile Map<String, Object> clientContext;
    private volatile HostAndPort lastDispatchedTo;
    private volatile NodeIdentifier lastDispatchedToNode;
    private volatile HostAndPort lastDispatchedFrom;
    private final AtomicReference<Set<RetryReason>> retryReasons = new AtomicReference<Object>(null);
    private final AtomicInteger retryAttempts;
    private volatile Duration lastRetryDuration;

    @Stability.Internal
    public RequestContext(CoreContext ctx, Request<? extends Response> request) {
        this(ctx.core(), ctx.id(), ctx.environment(), ctx.authenticator(), request);
    }

    @Stability.Internal
    public RequestContext(@Nullable Core core, long contextId, CoreEnvironment environment, Authenticator authenticator, Request<? extends Response> request) {
        super(core, contextId, environment, authenticator);
        this.request = Objects.requireNonNull(request);
        this.retryAttempts = new AtomicInteger(0);
    }

    @Stability.Volatile
    public long dispatchLatency() {
        return this.dispatchLatency;
    }

    @Stability.Internal
    public RequestContext dispatchLatency(long dispatchLatency) {
        this.dispatchLatency = dispatchLatency;
        this.totalDispatchLatency.addAndGet(dispatchLatency);
        return this;
    }

    public long totalDispatchLatency() {
        return this.totalDispatchLatency.get();
    }

    public long totalServerLatency() {
        return this.totalServerLatency.get();
    }

    @Stability.Volatile
    public long encodeLatency() {
        return this.encodeLatency;
    }

    @Stability.Internal
    public RequestContext encodeLatency(long encodeLatency) {
        this.encodeLatency = encodeLatency;
        return this;
    }

    @Stability.Volatile
    public String lastChannelId() {
        return this.lastChannelId;
    }

    @Stability.Internal
    public RequestContext lastChannelId(String lastChannelId) {
        this.lastChannelId = lastChannelId;
        return this;
    }

    @Stability.Volatile
    public long serverLatency() {
        return this.serverLatency;
    }

    @Stability.Internal
    public RequestContext serverLatency(long serverLatency) {
        this.serverLatency = serverLatency;
        this.totalServerLatency.addAndGet(serverLatency);
        return this;
    }

    @Stability.Internal
    public RequestContext logicallyComplete(@Nullable Throwable err) {
        long latency;
        this.logicallyCompletedAt = System.nanoTime();
        RequestSpan span = this.request.requestSpan();
        if (span != null) {
            if (!CbTracing.isInternalSpan(span)) {
                span.attribute("db.couchbase.retries", this.retryAttempts());
                if (err != null) {
                    span.recordException(err);
                    span.status(RequestSpan.StatusCode.ERROR);
                }
            }
            span.end();
        }
        if (!(this.environment().meter() instanceof NoopMeter) && (latency = this.logicalRequestLatency()) > 0L) {
            this.core().responseMetric(this.request).recordValue(latency);
        }
        return this;
    }

    @Stability.Internal
    public RequestContext logicallyComplete() {
        return this.logicallyComplete(null);
    }

    public int retryAttempts() {
        return this.retryAttempts.get();
    }

    public Set<RetryReason> retryReasons() {
        return this.retryReasons.get();
    }

    public Duration lastRetryDuration() {
        return this.lastRetryDuration;
    }

    public long logicallyCompletedAt() {
        return this.logicallyCompletedAt;
    }

    public long logicalRequestLatency() {
        long createdAt = this.request.createdAt();
        if (this.logicallyCompletedAt == 0L || this.logicallyCompletedAt <= createdAt) {
            return 0L;
        }
        return this.logicallyCompletedAt - createdAt;
    }

    @Stability.Internal
    public RequestContext incrementRetryAttempts(Duration lastRetryDuration, RetryReason reason) {
        Validators.notNull(lastRetryDuration, "Retry Duration");
        Validators.notNull(reason, "Retry Reason");
        this.retryReasons.getAndUpdate(retryReasons -> {
            if (retryReasons == null) {
                retryReasons = EnumSet.of(reason);
            } else {
                retryReasons.add(reason);
            }
            return retryReasons;
        });
        this.retryAttempts.incrementAndGet();
        this.lastRetryDuration = lastRetryDuration;
        return this;
    }

    public HostAndPort lastDispatchedTo() {
        return this.lastDispatchedTo;
    }

    @Stability.Internal
    public NodeIdentifier lastDispatchedToNode() {
        return this.lastDispatchedToNode;
    }

    @Stability.Internal
    public RequestContext lastDispatchedTo(HostAndPort lastDispatchedTo) {
        this.lastDispatchedTo = lastDispatchedTo;
        return this;
    }

    @Stability.Internal
    public RequestContext lastDispatchedToNode(NodeIdentifier lastDispatchedToNode) {
        this.lastDispatchedToNode = lastDispatchedToNode;
        return this;
    }

    public HostAndPort lastDispatchedFrom() {
        return this.lastDispatchedFrom;
    }

    @Stability.Internal
    public RequestContext lastDispatchedFrom(HostAndPort lastDispatchedFrom) {
        this.lastDispatchedFrom = lastDispatchedFrom;
        return this;
    }

    public Map<String, Object> clientContext() {
        return this.clientContext;
    }

    @Stability.Internal
    public RequestContext clientContext(@Nullable Map<String, Object> clientContext) {
        if (clientContext != null) {
            this.clientContext = clientContext;
        }
        return this;
    }

    public Request<? extends Response> request() {
        return this.request;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        Set<RetryReason> retryReasons;
        Map<String, Object> serviceContext;
        super.injectExportableParams(input);
        Request<? extends Response> request = this.request;
        input.put("requestId", request.id());
        input.put("idempotent", request.idempotent());
        input.put("requestType", request.getClass().getSimpleName());
        input.put("retried", this.retryAttempts());
        input.put("completed", request.completed());
        input.put("timeoutMs", request.timeout().toMillis());
        if (request.cancelled()) {
            input.put("cancelled", true);
            input.put("reason", request.cancellationReason());
        }
        if (this.clientContext != null) {
            input.put("clientContext", this.clientContext);
        }
        if ((serviceContext = request.serviceContext()) != null) {
            input.put("service", serviceContext);
        }
        if ((retryReasons = this.retryReasons()) != null) {
            input.put("retryReasons", retryReasons);
        }
        long logicalLatency = this.logicalRequestLatency();
        if (this.dispatchLatency != 0L || logicalLatency != 0L || this.encodeLatency != 0L || this.serverLatency != 0L) {
            HashMap<String, Long> timings = new HashMap<String, Long>();
            if (this.dispatchLatency != 0L) {
                timings.put("dispatchMicros", TimeUnit.NANOSECONDS.toMicros(this.dispatchLatency));
            }
            if (this.totalDispatchLatency.get() != 0L) {
                timings.put("totalDispatchMicros", TimeUnit.NANOSECONDS.toMicros(this.totalDispatchLatency.get()));
            }
            if (this.serverLatency != 0L) {
                timings.put("serverMicros", TimeUnit.NANOSECONDS.toMicros(this.serverLatency));
            }
            if (this.totalServerLatency.get() != 0L) {
                timings.put("totalServerMicros", TimeUnit.NANOSECONDS.toMicros(this.totalServerLatency.get()));
            }
            if (logicalLatency != 0L) {
                timings.put("totalMicros", TimeUnit.NANOSECONDS.toMicros(logicalLatency));
            }
            if (this.encodeLatency != 0L) {
                timings.put("encodingMicros", TimeUnit.NANOSECONDS.toMicros(this.encodeLatency));
            }
            input.put("timings", timings);
        }
        if (this.lastDispatchedTo != null) {
            input.put("lastDispatchedTo", RedactableArgument.redactSystem(this.lastDispatchedTo));
        } else if (this.lastDispatchedToNode != null) {
            input.put("lastDispatchedTo", RedactableArgument.redactSystem(this.lastDispatchedToNode.address()));
        }
        if (this.lastDispatchedFrom != null) {
            input.put("lastDispatchedFrom", RedactableArgument.redactSystem(this.lastDispatchedFrom));
        }
        if (this.lastChannelId != null) {
            input.put("lastChannelId", RedactableArgument.redactMeta(this.lastChannelId));
        }
    }

    @Stability.Uncommitted
    public RequestContext cancel() {
        this.request.cancel(CancellationReason.CANCELLED_VIA_CONTEXT);
        return this;
    }
}

