/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.grpc.CallCredentials;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.OwnedSupplier;
import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.io.netty.kv.SaslAuthenticationHandler;
import com.couchbase.client.core.io.netty.kv.SaslListMechanismsHandler;
import com.couchbase.client.core.io.netty.kv.sasl.SaslHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class PasswordAuthenticator
implements Authenticator {
    private static final Set<SaslMechanism> DEFAULT_SASL_MECHANISMS = EnumSet.of(SaslMechanism.SCRAM_SHA512, SaslMechanism.SCRAM_SHA256, SaslMechanism.SCRAM_SHA1);
    private final Supplier<String> username;
    private final Supplier<String> password;
    private final Set<SaslMechanism> allowedSaslMechanisms;
    private final String cachedHttpAuthHeader;

    public static Builder builder() {
        return new Builder();
    }

    public static PasswordAuthenticator create(String username, String password) {
        return PasswordAuthenticator.builder().username(username).password(password).build();
    }

    public static PasswordAuthenticator ldapCompatible(String username, String password) {
        return PasswordAuthenticator.builder().username(username).password(password).onlyEnablePlainSaslMechanism().build();
    }

    private PasswordAuthenticator(Builder builder) {
        this.username = Validators.notNull(builder.username, "username");
        this.password = Validators.notNull(builder.password, "password");
        this.allowedSaslMechanisms = Validators.notNull(builder.allowedSaslMechanisms, "allowedSaslMechanisms");
        this.cachedHttpAuthHeader = this.username instanceof OwnedSupplier && this.password instanceof OwnedSupplier ? this.encodeAuthHttpHeader() : null;
    }

    private String encodeAuthHttpHeader() {
        String password = this.password.get();
        String username = this.username.get();
        String pw = password == null ? "" : password;
        String encoded = Base64.getEncoder().encodeToString((username + ":" + pw).getBytes(StandardCharsets.UTF_8));
        return "Basic " + encoded;
    }

    @Override
    public void authKeyValueConnection(EndpointContext ctx, ChannelPipeline pipeline) {
        boolean tls = ctx.environment().securityConfig().tlsEnabled();
        boolean forceSaslPlain = tls && SaslHelper.platformHasSaslPlain();
        pipeline.addLast(new SaslListMechanismsHandler(ctx));
        pipeline.addLast(new SaslAuthenticationHandler(ctx, this.username.get(), this.password.get(), forceSaslPlain ? EnumSet.of(SaslMechanism.PLAIN) : this.allowedSaslMechanisms));
    }

    @Override
    public void authHttpRequest(ServiceType serviceType, HttpRequest request) {
        request.headers().add((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)(this.cachedHttpAuthHeader != null ? this.cachedHttpAuthHeader : this.encodeAuthHttpHeader()));
    }

    @Override
    public CallCredentials protostellarCallCredentials() {
        return new CallCredentials(){

            @Override
            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
                executor.execute(() -> {
                    try {
                        Metadata headers = new Metadata();
                        headers.put(Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER), PasswordAuthenticator.this.encodeAuthHttpHeader());
                        applier.apply(headers);
                    }
                    catch (Throwable e) {
                        applier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                });
            }

            @Override
            public void thisUsesUnstableApi() {
            }
        };
    }

    static /* synthetic */ Set access$400() {
        return DEFAULT_SASL_MECHANISMS;
    }

    public static class Builder {
        private Supplier<String> username;
        private Supplier<String> password;
        private Set<SaslMechanism> allowedSaslMechanisms = PasswordAuthenticator.access$400();
        private Supplier<Boolean> platformHasSaslPlain = SaslHelper::platformHasSaslPlain;

        public Builder username(String username) {
            Validators.notNullOrEmpty(username, "Username");
            return this.username(new OwnedSupplier<String>(username));
        }

        public Builder username(Supplier<String> username) {
            Validators.notNull(username, "Username");
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            Validators.notNullOrEmpty(password, "Password");
            return this.password(new OwnedSupplier<String>(password));
        }

        public Builder password(Supplier<String> password) {
            Validators.notNull(password, "Password");
            this.password = password;
            return this;
        }

        public Builder allowedSaslMechanisms(Set<SaslMechanism> allowedSaslMechanisms) {
            Validators.notNullOrEmpty(allowedSaslMechanisms, "AllowedSaslMechanisms");
            if (allowedSaslMechanisms.equals(CbCollections.setOf(SaslMechanism.PLAIN)) && !this.platformHasSaslPlain.get().booleanValue()) {
                throw new RuntimeException("This JVM is running in a restricted mode that prevents using SASL PLAIN for authentication.");
            }
            this.allowedSaslMechanisms = allowedSaslMechanisms;
            return this;
        }

        public Builder enablePlainSaslMechanism() {
            return this.allowedSaslMechanisms(EnumSet.allOf(SaslMechanism.class));
        }

        public Builder onlyEnablePlainSaslMechanism() {
            return this.allowedSaslMechanisms(EnumSet.of(SaslMechanism.PLAIN));
        }

        @Stability.Internal
        Builder setPlatformHasSaslPlain(Supplier<Boolean> saslPlainAvailable) {
            this.platformHasSaslPlain = Objects.requireNonNull(saslPlainAvailable);
            return this;
        }

        public PasswordAuthenticator build() {
            return new PasswordAuthenticator(this);
        }
    }
}

