/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.service.ServiceType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClusterConfig {
    private final Map<String, BucketConfig> bucketConfigs = new ConcurrentHashMap<String, BucketConfig>();
    private final AtomicReference<GlobalConfig> globalConfig = new AtomicReference();

    public BucketConfig bucketConfig(String bucketName) {
        return this.bucketConfigs.get(bucketName);
    }

    @Stability.Internal
    public void setBucketConfig(BucketConfig config) {
        this.bucketConfigs.put(config.name(), config);
    }

    @Stability.Internal
    public void deleteBucketConfig(String bucketName) {
        this.bucketConfigs.remove(bucketName);
    }

    public Map<String, BucketConfig> bucketConfigs() {
        return this.bucketConfigs;
    }

    public GlobalConfig globalConfig() {
        return this.globalConfig.get();
    }

    @Stability.Internal
    public void setGlobalConfig(GlobalConfig config) {
        this.globalConfig.set(config);
    }

    @Stability.Internal
    public void deleteGlobalConfig() {
        this.globalConfig.set(null);
    }

    public boolean hasClusterOrBucketConfig() {
        return !this.bucketConfigs.isEmpty() || this.globalConfig() != null;
    }

    public Set<String> allNodeAddresses() {
        HashSet<String> nodes = new HashSet<String>();
        GlobalConfig gc = this.globalConfig.get();
        if (gc != null) {
            for (PortInfo ni : gc.portInfos()) {
                nodes.add(ni.hostname());
            }
        }
        for (BucketConfig bc : this.bucketConfigs().values()) {
            for (NodeInfo ni : bc.nodes()) {
                nodes.add(ni.hostname());
            }
        }
        return nodes;
    }

    public String toString() {
        return "ClusterConfig{bucketConfigs=" + this.bucketConfigs + ", globalConfig=" + this.globalConfig + '}';
    }

    public Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities() {
        Iterator<BucketConfig> iterator = this.bucketConfigs().values().iterator();
        if (iterator.hasNext()) {
            BucketConfig bc = iterator.next();
            return bc.clusterCapabilities();
        }
        return Collections.emptyMap();
    }
}

