/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.search.CoreSearchIndex;
import com.couchbase.client.core.api.manager.search.CoreSearchIndexManager;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public abstract class ClassicCoreBaseSearchIndexManager
implements CoreSearchIndexManager {
    private final Core core;
    private final CoreHttpClient searchHttpClient;

    @Stability.Internal
    public ClassicCoreBaseSearchIndexManager(Core core) {
        this.core = core;
        this.searchHttpClient = core.httpClient(RequestTarget.search());
    }

    protected static String globalIndexesPath() {
        return "/api/index";
    }

    protected static String globalIndexPath(String indexName) {
        return ClassicCoreBaseSearchIndexManager.globalIndexesPath() + "/" + UrlQueryStringBuilder.urlEncode(indexName);
    }

    abstract String indexesPath();

    String indexPath(String indexName) {
        return this.indexesPath() + "/" + UrlQueryStringBuilder.urlEncode(indexName);
    }

    String indexCountPath(String indexName) {
        return this.indexPath(indexName) + "/count";
    }

    String analyzeDocumentPath(String indexName) {
        return this.indexPath(indexName) + "/analyzeDoc";
    }

    String pauseIngestPath(String indexName) {
        return this.indexPath(indexName) + "/ingestControl/pause";
    }

    String resumeIngestPath(String indexName) {
        return this.indexPath(indexName) + "/ingestControl/resume";
    }

    String allowQueryingPath(String indexName) {
        return this.indexPath(indexName) + "/queryControl/allow";
    }

    String disallowQueryingPath(String indexName) {
        return this.indexPath(indexName) + "/queryControl/disallow";
    }

    String freezePlanPath(String indexName) {
        return this.indexPath(indexName) + "/planFreezeControl/freeze";
    }

    String unfreezePlanPath(String indexName) {
        return this.indexPath(indexName) + "/planFreezeControl/unfreeze";
    }

    @Override
    public CompletableFuture<CoreSearchIndex> getIndex(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        RequestSpan span = CbTracing.newSpan(this.core.context(), "manager_search_get_index", (RequestSpan)options.parentSpan().orElse(null));
        return ((CompletableFuture)this.getAllIndexes(CoreCommonOptions.of(null, null, span)).thenApply(indexes -> indexes.stream().filter(i -> i.name().equals(name)).findFirst().orElseThrow(() -> new IndexNotFoundException(name)))).whenComplete((r, t) -> span.end());
    }

    @Override
    public CompletableFuture<List<CoreSearchIndex>> getAllIndexes(CoreCommonOptions options) {
        return this.searchHttpClient.get(CoreHttpPath.path(this.indexesPath()), options).trace("manager_search_get_all_indexes").exec(this.core).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree(response.content());
            JsonNode indexDefs = rootNode.get("indexDefs").get("indexDefs");
            Map<String, CoreSearchIndex> indexes = Mapper.convertValue((Object)indexDefs, new TypeReference<Map<String, CoreSearchIndex>>(){});
            return indexes == null ? Collections.emptyList() : new ArrayList<CoreSearchIndex>(indexes.values());
        });
    }

    @Override
    public CompletableFuture<Long> getIndexedDocumentsCount(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.get(CoreHttpPath.path(this.indexCountPath(name)), options).trace("manager_search_get_indexed_documents_count").exec(this.core).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree(response.content());
            return rootNode.get("count").asLong();
        });
    }

    @Override
    public CompletableFuture<Void> upsertIndex(CoreSearchIndex index, CoreCommonOptions options) {
        Validators.notNull(index, "Search Index");
        return this.searchHttpClient.put(CoreHttpPath.path(this.indexPath(index.name())), options).trace("manager_search_upsert_index").json(index.toJson().getBytes(StandardCharsets.UTF_8)).header(HttpHeaderNames.CACHE_CONTROL, "no-cache").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<Void> dropIndex(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.delete(CoreHttpPath.path(this.indexPath(name)), options).trace("manager_search_drop_index").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<List<ObjectNode>> analyzeDocument(String name, ObjectNode document, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        Validators.notNull(document, "Document");
        return ((CompletableFuture)this.searchHttpClient.post(CoreHttpPath.path(this.analyzeDocumentPath(name)), options).trace("manager_search_analyze_document").json(Mapper.encodeAsBytes(document)).exec(this.core).exceptionally(throwable -> {
            if (throwable.getMessage().contains("Page not found")) {
                throw new FeatureNotAvailableException("Document analysis is not available on this server version!");
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CouchbaseException("Failed to analyze search document", (Throwable)throwable);
        })).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree(response.content());
            return Mapper.convertValue((Object)rootNode.get("analyzed"), new TypeReference<List<ObjectNode>>(){});
        });
    }

    @Override
    public CompletableFuture<Void> pauseIngest(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.post(CoreHttpPath.path(this.pauseIngestPath(name)), options).trace("manager_search_pause_ingest").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<Void> resumeIngest(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.post(CoreHttpPath.path(this.resumeIngestPath(name)), options).trace("manager_search_resume_ingest").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<Void> allowQuerying(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.post(CoreHttpPath.path(this.allowQueryingPath(name)), options).trace("manager_search_allow_querying").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<Void> disallowQuerying(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.post(CoreHttpPath.path(this.disallowQueryingPath(name)), options).trace("manager_search_disallow_querying").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<Void> freezePlan(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.post(CoreHttpPath.path(this.freezePlanPath(name)), options).trace("manager_search_freeze_plan").exec(this.core).thenApply(response -> null);
    }

    @Override
    public CompletableFuture<Void> unfreezePlan(String name, CoreCommonOptions options) {
        this.validateSearchParams(name, options);
        return this.searchHttpClient.post(CoreHttpPath.path(this.unfreezePlanPath(name)), options).trace("manager_search_unfreeze_plan").exec(this.core).thenApply(response -> null);
    }

    private void validateSearchParams(String name, CoreCommonOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        Validators.notNull(options, "Search Index Options");
    }
}

