/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreKvResponseMetadata;
import com.couchbase.client.core.api.kv.CoreKvResult;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreSubdocGetResult
extends CoreKvResult {
    private final long cas;
    private final boolean tombstone;
    private final List<SubDocumentField> fields;

    public CoreSubdocGetResult(CoreKeyspace keyspace, String key, @Nullable CoreKvResponseMetadata meta, List<SubDocumentField> fields, long cas, boolean tombstone) {
        super(keyspace, key, meta);
        this.fields = Objects.requireNonNull(fields);
        this.cas = cas;
        this.tombstone = tombstone;
    }

    public List<SubDocumentField> fields() {
        return this.fields;
    }

    public SubDocumentField field(int index) {
        try {
            return this.fields.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw InvalidArgumentException.fromMessage("Index " + index + " is out of bounds; must be >= 0 and < " + this.fields.size(), e);
        }
    }

    public boolean exists(int index) {
        SubDocumentField field = this.field(index);
        CouchbaseException error = field.error().orElse(null);
        if (error == null) {
            return true;
        }
        if (error instanceof PathNotFoundException) {
            return false;
        }
        throw error;
    }

    public long cas() {
        return this.cas;
    }

    public boolean tombstone() {
        return this.tombstone;
    }

    public String toString() {
        return "CoreSubdocGetResult{cas=" + this.cas + ", tombstone=" + this.tombstone + ", fields=" + RedactableArgument.redactUser(this.fields) + '}';
    }
}

