/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ErrorContext;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class Validators {
    private Validators() {
    }

    public static <T> T notNull(T input, String identifier) {
        if (input == null) {
            throw InvalidArgumentException.fromMessage(identifier + " cannot be null");
        }
        return input;
    }

    public static <T> T notNull(T input, String identifier, Supplier<ErrorContext> errorContext) {
        try {
            return Validators.notNull(input, identifier);
        }
        catch (Exception cause) {
            throw new InvalidArgumentException("Argument validation failed", cause, errorContext.get());
        }
    }

    public static String notNullOrEmpty(String input, String identifier) {
        if (input == null || input.isEmpty()) {
            throw InvalidArgumentException.fromMessage(identifier + " cannot be null or empty");
        }
        return input;
    }

    public static String notNullOrEmpty(String input, String identifier, Supplier<ErrorContext> errorContext) {
        try {
            return Validators.notNullOrEmpty(input, identifier);
        }
        catch (Exception cause) {
            throw new InvalidArgumentException("Argument validation failed", cause, errorContext.get());
        }
    }

    public static <T> List<T> notNullOrEmpty(List<T> input, String identifier) {
        if (input == null || input.isEmpty()) {
            throw InvalidArgumentException.fromMessage(identifier + " cannot be null or empty");
        }
        return input;
    }

    public static <T> List<T> notNullOrEmpty(List<T> input, String identifier, Supplier<ErrorContext> errorContext) {
        try {
            return Validators.notNullOrEmpty(input, identifier);
        }
        catch (Exception cause) {
            throw new InvalidArgumentException("Argument validation failed", cause, errorContext.get());
        }
    }

    public static <T> Set<T> notNullOrEmpty(Set<T> input, String identifier) {
        if (input == null || input.isEmpty()) {
            throw InvalidArgumentException.fromMessage(identifier + " cannot be null or empty");
        }
        return input;
    }

    public static <T> Set<T> notNullOrEmpty(Set<T> input, String identifier, Supplier<ErrorContext> errorContext) {
        try {
            return Validators.notNullOrEmpty(input, identifier);
        }
        catch (Exception cause) {
            throw new InvalidArgumentException("Argument validation failed", cause, errorContext.get());
        }
    }
}

