/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

public class MutationToken {
    private final short partitionID;
    private final long partitionUUID;
    private final long sequenceNumber;
    private final String bucketName;

    public MutationToken(short partitionID, long partitionUUID, long sequenceNumber, String bucketName) {
        this.partitionID = partitionID;
        this.partitionUUID = partitionUUID;
        this.sequenceNumber = sequenceNumber;
        this.bucketName = bucketName;
    }

    public long partitionUUID() {
        return this.partitionUUID;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public short partitionID() {
        return this.partitionID;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationToken that = (MutationToken)o;
        return this.partitionID == that.partitionID && this.partitionUUID == that.partitionUUID && this.sequenceNumber == that.sequenceNumber && Objects.equals(this.bucketName, that.bucketName);
    }

    public int hashCode() {
        return Objects.hash(this.partitionID, this.partitionUUID, this.sequenceNumber, this.bucketName);
    }

    public String toString() {
        return "mt{vbID=" + this.partitionID + ", vbUUID=" + this.partitionUUID + ", seqno=" + this.sequenceNumber + ", bucket=" + RedactableArgument.redactMeta(this.bucketName) + '}';
    }
}

