/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;

public class ThresholdLoggingTracerConfig {
    private final boolean enabled;
    private final Duration emitInterval;
    private final int queueLength;
    private final int sampleSize;
    private final Duration kvThreshold;
    private final Duration queryThreshold;
    private final Duration viewThreshold;
    private final Duration searchThreshold;
    private final Duration analyticsThreshold;

    public static Builder builder() {
        return new Builder();
    }

    public static ThresholdLoggingTracerConfig create() {
        return ThresholdLoggingTracerConfig.builder().build();
    }

    public static ThresholdLoggingTracerConfig disabled() {
        return ThresholdLoggingTracerConfig.enabled(false).build();
    }

    ThresholdLoggingTracerConfig(Builder builder) {
        this.emitInterval = builder.emitInterval;
        this.queueLength = builder.queueLength;
        this.sampleSize = builder.sampleSize;
        this.kvThreshold = builder.kvThreshold;
        this.queryThreshold = builder.queryThreshold;
        this.viewThreshold = builder.viewThreshold;
        this.searchThreshold = builder.searchThreshold;
        this.analyticsThreshold = builder.analyticsThreshold;
        this.enabled = builder.enabled;
    }

    public static Builder enabled(boolean enabled) {
        return ThresholdLoggingTracerConfig.builder().enabled(enabled);
    }

    public static Builder sampleSize(int sampleSize) {
        return ThresholdLoggingTracerConfig.builder().sampleSize(sampleSize);
    }

    public static Builder emitInterval(Duration emitInterval) {
        return ThresholdLoggingTracerConfig.builder().emitInterval(emitInterval);
    }

    public static Builder queueLength(int queueLength) {
        return ThresholdLoggingTracerConfig.builder().queueLength(queueLength);
    }

    public static Builder kvThreshold(Duration kvThreshold) {
        return ThresholdLoggingTracerConfig.builder().kvThreshold(kvThreshold);
    }

    public static Builder analyticsThreshold(Duration analyticsThreshold) {
        return ThresholdLoggingTracerConfig.builder().analyticsThreshold(analyticsThreshold);
    }

    public static Builder queryThreshold(Duration queryThreshold) {
        return ThresholdLoggingTracerConfig.builder().queryThreshold(queryThreshold);
    }

    public static Builder searchThreshold(Duration searchThreshold) {
        return ThresholdLoggingTracerConfig.builder().searchThreshold(searchThreshold);
    }

    public static Builder viewThreshold(Duration viewThreshold) {
        return ThresholdLoggingTracerConfig.builder().viewThreshold(viewThreshold);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Duration emitInterval() {
        return this.emitInterval;
    }

    public int queueLength() {
        return this.queueLength;
    }

    public int sampleSize() {
        return this.sampleSize;
    }

    public Duration kvThreshold() {
        return this.kvThreshold;
    }

    public Duration queryThreshold() {
        return this.queryThreshold;
    }

    public Duration viewThreshold() {
        return this.viewThreshold;
    }

    public Duration searchThreshold() {
        return this.searchThreshold;
    }

    public Duration analyticsThreshold() {
        return this.analyticsThreshold;
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("enabled", this.enabled);
        export.put("emitIntervalMs", this.emitInterval.toMillis());
        export.put("sampleSize", this.sampleSize);
        export.put("queueLength", this.queueLength);
        export.put("kvThresholdMs", this.kvThreshold.toMillis());
        export.put("queryThresholdMs", this.queryThreshold.toMillis());
        export.put("searchThresholdMs", this.searchThreshold.toMillis());
        export.put("analyticsThresholdMs", this.analyticsThreshold.toMillis());
        export.put("viewThresholdMs", this.viewThreshold.toMillis());
        return export;
    }

    public static class Builder {
        private boolean enabled = true;
        private Duration emitInterval = Defaults.DEFAULT_EMIT_INTERVAL;
        private int queueLength = 1024;
        private int sampleSize = 10;
        private Duration kvThreshold = Defaults.DEFAULT_KV_THRESHOLD;
        private Duration queryThreshold = Defaults.DEFAULT_QUERY_THRESHOLD;
        private Duration viewThreshold = Defaults.DEFAULT_VIEW_THRESHOLD;
        private Duration searchThreshold = Defaults.DEFAULT_SEARCH_THRESHOLD;
        private Duration analyticsThreshold = Defaults.DEFAULT_ANALYTICS_THRESHOLD;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder emitInterval(Duration emitInterval) {
            if (emitInterval.isZero()) {
                throw InvalidArgumentException.fromMessage("Emit interval needs to be greater than 0");
            }
            this.emitInterval = emitInterval;
            return this;
        }

        public Builder queueLength(int queueLength) {
            this.queueLength = queueLength;
            return this;
        }

        public Builder kvThreshold(Duration kvThreshold) {
            this.kvThreshold = kvThreshold;
            return this;
        }

        public Builder queryThreshold(Duration queryThreshold) {
            this.queryThreshold = queryThreshold;
            return this;
        }

        public Builder viewThreshold(Duration viewThreshold) {
            this.viewThreshold = viewThreshold;
            return this;
        }

        public Builder searchThreshold(Duration searchThreshold) {
            this.searchThreshold = searchThreshold;
            return this;
        }

        public Builder analyticsThreshold(Duration analyticsThreshold) {
            this.analyticsThreshold = analyticsThreshold;
            return this;
        }

        public Builder sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public ThresholdLoggingTracerConfig build() {
            return new ThresholdLoggingTracerConfig(this);
        }
    }

    @Stability.Internal
    public static class Defaults {
        public static final boolean DEFAULT_ENABLED = true;
        public static final Duration DEFAULT_EMIT_INTERVAL = Duration.ofSeconds(10L);
        public static final int DEFAULT_QUEUE_LENGTH = 1024;
        public static final Duration DEFAULT_KV_THRESHOLD = Duration.ofMillis(500L);
        public static final Duration DEFAULT_QUERY_THRESHOLD = Duration.ofSeconds(1L);
        public static final Duration DEFAULT_VIEW_THRESHOLD = Duration.ofSeconds(1L);
        public static final Duration DEFAULT_SEARCH_THRESHOLD = Duration.ofSeconds(1L);
        public static final Duration DEFAULT_ANALYTICS_THRESHOLD = Duration.ofSeconds(1L);
        public static final int DEFAULT_SAMPLE_SIZE = 10;
    }
}

