/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class CoreHttpTimeoutHelper {
    private static final Map<ServiceType, Function<TimeoutConfig, Duration>> serviceTypeToDefaultTimeout;

    private CoreHttpTimeoutHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Duration resolveTimeout(CoreContext coreContext, ServiceType serviceType, Optional<Duration> timeout) {
        Objects.requireNonNull(coreContext);
        Objects.requireNonNull(serviceType);
        return timeout.orElseGet(() -> serviceTypeToDefaultTimeout.getOrDefault((Object)serviceType, x -> {
            throw new RuntimeException("Can't find default timeout for " + (Object)((Object)serviceType) + " service.");
        }).apply(coreContext.environment().timeoutConfig()));
    }

    static {
        EnumMap<ServiceType, Function<TimeoutConfig, Duration>> map = new EnumMap<ServiceType, Function<TimeoutConfig, Duration>>(ServiceType.class);
        map.put(ServiceType.ANALYTICS, TimeoutConfig::analyticsTimeout);
        map.put(ServiceType.EVENTING, TimeoutConfig::eventingTimeout);
        map.put(ServiceType.KV, TimeoutConfig::kvTimeout);
        map.put(ServiceType.MANAGER, TimeoutConfig::managementTimeout);
        map.put(ServiceType.QUERY, TimeoutConfig::queryTimeout);
        map.put(ServiceType.SEARCH, TimeoutConfig::searchTimeout);
        map.put(ServiceType.VIEWS, TimeoutConfig::viewTimeout);
        serviceTypeToDefaultTimeout = Collections.unmodifiableMap(map);
    }
}

