/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseKeyValueRequest<R extends Response>
extends BaseRequest<R>
implements KeyValueRequest<R> {
    private static final AtomicInteger GLOBAL_OPAQUE = new AtomicInteger(0);
    private static final int MAX_KEY_BYTES = 250;
    private final byte[] key;
    private final CollectionIdentifier collectionIdentifier;
    private final int opaque;
    private volatile short partition;
    private final AtomicInteger rejectedWithNotMyVbucket = new AtomicInteger(0);

    protected BaseKeyValueRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, String key, CollectionIdentifier collectionIdentifier) {
        this(timeout, ctx, retryStrategy, key, collectionIdentifier, null);
    }

    protected BaseKeyValueRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, String key, CollectionIdentifier collectionIdentifier, RequestSpan span) {
        super(timeout, ctx, retryStrategy, span);
        this.key = BaseKeyValueRequest.encodeKey(key);
        this.collectionIdentifier = collectionIdentifier;
        this.opaque = BaseKeyValueRequest.nextOpaque();
        if (span != null) {
            span.attribute("db.couchbase.service", "kv");
            if (collectionIdentifier != null) {
                span.attribute("db.name", collectionIdentifier.bucket());
                span.attribute("db.couchbase.scope", collectionIdentifier.scope().orElse("_default"));
                span.attribute("db.couchbase.collection", collectionIdentifier.collection().orElse("_default"));
            }
        }
    }

    public static int nextOpaque() {
        return GLOBAL_OPAQUE.getAndIncrement();
    }

    @Override
    public short partition() {
        return this.partition;
    }

    @Override
    public void partition(short partition) {
        this.partition = partition;
    }

    static byte[] encodeKey(String key) {
        return key == null || key.isEmpty() ? Bytes.EMPTY_BYTE_ARRAY : key.getBytes(StandardCharsets.UTF_8);
    }

    protected ByteBuf encodedKeyWithCollection(ByteBufAllocator alloc, KeyValueChannelContext ctx) {
        return this.encodedExternalKeyWithCollection(alloc, ctx, this.key);
    }

    protected ByteBuf encodedExternalKeyWithCollection(ByteBufAllocator alloc, KeyValueChannelContext ctx, byte[] key) {
        if (ctx.collectionsEnabled()) {
            byte[] collection = ctx.collectionMap().get(this.collectionIdentifier);
            if (collection == null) {
                throw CollectionNotFoundException.forCollection(this.collectionIdentifier.collection().orElse(""));
            }
            int totalLength = key.length + collection.length;
            this.checkKeyLength(totalLength);
            return alloc.buffer(totalLength).writeBytes(collection).writeBytes(key);
        }
        if (this.collectionIdentifier.isDefault()) {
            this.checkKeyLength(key.length);
            return alloc.buffer(key.length).writeBytes(key);
        }
        throw new FeatureNotAvailableException("Collections are not supported (or enabled) on the cluster");
    }

    private void checkKeyLength(int length) {
        if (length > 250) {
            throw new InvalidArgumentException("The key must not be longer than 250 bytes (was " + length + " bytes including the collection prefix).", null, ReducedKeyValueErrorContext.create(new String(this.key, StandardCharsets.UTF_8), this.collectionIdentifier));
        }
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.KV;
    }

    @Override
    public int opaque() {
        return this.opaque;
    }

    @Override
    public Map<String, Object> serviceContext() {
        int nmvb;
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("opaque", this.operationId());
        if (this.collectionIdentifier != null) {
            ctx.put("bucket", RedactableArgument.redactMeta(this.collectionIdentifier.bucket()));
            ctx.put("scope", RedactableArgument.redactMeta(this.collectionIdentifier.scope().orElse("_default")));
            ctx.put("collection", RedactableArgument.redactMeta(this.collectionIdentifier.collection().orElse("_default")));
        }
        if (this.key != null && this.key.length > 0) {
            ctx.put("documentId", RedactableArgument.redactUser(new String(this.key, StandardCharsets.UTF_8)));
        }
        if (this instanceof SyncDurabilityRequest) {
            ((SyncDurabilityRequest)((Object)this)).durabilityLevel().ifPresent(d -> ctx.put("syncDurability", d));
        }
        if ((nmvb = this.rejectedWithNotMyVbucket.get()) > 0) {
            ctx.put("rejectedWithNotMyVbucket", nmvb);
        }
        return ctx;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public String bucket() {
        return this.collectionIdentifier == null ? null : this.collectionIdentifier.bucket();
    }

    @Override
    public CollectionIdentifier collectionIdentifier() {
        return this.collectionIdentifier;
    }

    @Override
    public String operationId() {
        return "0x" + Integer.toHexString(this.opaque);
    }

    @Override
    public int rejectedWithNotMyVbucket() {
        return this.rejectedWithNotMyVbucket.get();
    }

    @Override
    public void indicateRejectedWithNotMyVbucket() {
        this.rejectedWithNotMyVbucket.incrementAndGet();
    }
}

