/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.CompilationFailureException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.AnalyticsErrorContext;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public class CoreAnalyticsLinkManager {
    public static final String S3_TYPE_NAME = "s3";
    public static final String AZURE_BLOB_TYPE_NAME = "azureblob";
    public static final String COUCHBASE_TYPE_NAME = "couchbase";
    private final Core core;
    private final CoreHttpClient httpClient;

    public CoreAnalyticsLinkManager(Core core) {
        this.core = Objects.requireNonNull(core);
        this.httpClient = core.httpClient(RequestTarget.analytics());
    }

    public CompletableFuture<Void> createLink(Map<String, String> link, CoreCommonOptions options) {
        return this.sendLink(HttpMethod.POST, link, options, "manager_analytics_create_link");
    }

    public CompletableFuture<Void> replaceLink(Map<String, String> link, CoreCommonOptions options) {
        return this.sendLink(HttpMethod.PUT, link, options, "manager_analytics_replace_link");
    }

    public CompletableFuture<Void> dropLink(String linkName, String dataverse, CoreCommonOptions options) {
        HashMap<String, String> link = new HashMap<String, String>();
        link.put("dataverse", dataverse);
        link.put("name", linkName);
        return this.sendLink(HttpMethod.DELETE, link, options, "manager_analytics_drop_link");
    }

    private CompletableFuture<Void> sendLink(HttpMethod method, Map<String, String> link, CoreCommonOptions options, String tracingId) {
        link = new HashMap<String, String>(link);
        CoreHttpPath path = CoreAnalyticsLinkManager.getLinkPathAndAdjustMap(link);
        UrlQueryStringBuilder form = CoreHttpRequest.Builder.newForm();
        link.forEach(form::set);
        return ((CompletableFuture)this.httpClient.newRequest(method, path, options).trace(tracingId).form(form).exec(this.core).exceptionally(t -> {
            throw CoreAnalyticsLinkManager.translateCompilationFailureToInvalidArgument(t);
        })).thenApply(result -> null);
    }

    private static RuntimeException translateCompilationFailureToInvalidArgument(Throwable t) {
        if (!(t.getCause() instanceof CompilationFailureException)) {
            CbThrowables.throwIfUnchecked(t);
            throw new CouchbaseException(t.getMessage(), t);
        }
        CompilationFailureException e = (CompilationFailureException)t.getCause();
        String message = ((AnalyticsErrorContext)e.context()).errors().get(0).message();
        throw new InvalidArgumentException(message, e.getCause(), e.context());
    }

    private static CoreHttpPath getLinkPathAndAdjustMap(Map<String, String> link) {
        String dataverse = Objects.requireNonNull(link.get("dataverse"), "Link is missing 'dataverse' property");
        String linkName = Objects.requireNonNull(link.get("name"), "Link is missing 'name' property");
        if (dataverse.contains("/")) {
            link.remove("dataverse");
            link.remove("name");
            return CoreHttpPath.path("/analytics/link/{dataverse}/{linkName}", CbCollections.mapOf("dataverse", dataverse, "linkName", linkName));
        }
        return CoreHttpPath.path("/analytics/link");
    }

    public CompletableFuture<byte[]> getAllLinks(String dataverseName, String linkType, CoreCommonOptions options) {
        CoreHttpPath path;
        UrlQueryStringBuilder queryString = CoreHttpRequest.Builder.newQueryString();
        if (linkType != null) {
            queryString.set("type", linkType);
        }
        if (dataverseName == null) {
            path = CoreHttpPath.path("/analytics/link");
        } else if (dataverseName.contains("/")) {
            path = CoreHttpPath.path("/analytics/link/{dataverse}", CbCollections.mapOf("dataverse", dataverseName));
        } else {
            path = CoreHttpPath.path("/analytics/link");
            queryString.set("dataverse", dataverseName);
        }
        return this.httpClient.get(path, options).queryString(queryString).trace("manager_analytics_get_all_links").exec(this.core).thenApply(CoreHttpResponse::content);
    }
}

