/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.BucketNotFlushableException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerRequest;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public abstract class AbstractManagerSupport {
    final Core core;

    protected AbstractManagerSupport(Core core) {
        this.core = Objects.requireNonNull(core);
    }

    protected CompletableFuture<GenericManagerResponse> sendRequest(GenericManagerRequest request) {
        this.core.send(request);
        return request.response();
    }

    protected CompletableFuture<GenericManagerResponse> sendRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retry, RequestSpan span) {
        return this.sendRequest(new GenericManagerRequest(timeout, this.core.context(), retry, () -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), method == HttpMethod.GET, span)).whenComplete((r, t) -> span.end());
    }

    @Deprecated
    protected CompletableFuture<GenericManagerResponse> sendRequest(HttpMethod method, String path, RequestSpan span) {
        return this.sendRequest(new GenericManagerRequest(this.core.context(), () -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), method == HttpMethod.GET, span)).whenComplete((r, t) -> span.end());
    }

    protected CompletableFuture<GenericManagerResponse> sendRequest(HttpMethod method, String path, UrlQueryStringBuilder body, Duration timeout, RetryStrategy retry, RequestSpan span) {
        return this.sendRequest(new GenericManagerRequest(timeout, this.core.context(), retry, () -> {
            ByteBuf content = Unpooled.copiedBuffer(body.build(), StandardCharsets.UTF_8);
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path, content);
            req.headers().add("Content-Type", (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            req.headers().add("Content-Length", (Object)content.readableBytes());
            return req;
        }, method == HttpMethod.GET, span)).whenComplete((r, t) -> span.end());
    }

    @Deprecated
    protected CompletableFuture<GenericManagerResponse> sendRequest(HttpMethod method, String path, UrlQueryStringBuilder body, RequestSpan span) {
        return this.sendRequest(new GenericManagerRequest(this.core.context(), () -> {
            ByteBuf content = Unpooled.copiedBuffer(body.build(), StandardCharsets.UTF_8);
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path, content);
            req.headers().add("Content-Type", (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            req.headers().add("Content-Length", (Object)content.readableBytes());
            return req;
        }, method == HttpMethod.GET, span)).whenComplete((r, t) -> {
            if (span != null) {
                span.end();
            }
        });
    }

    protected static void checkStatus(GenericManagerResponse response, String action, String scope) {
        String content;
        String string = content = response.content() != null ? new String(response.content(), StandardCharsets.UTF_8) : "";
        if (response.status() == ResponseStatus.INVALID_ARGS && content.contains("Flush is disabled")) {
            throw BucketNotFlushableException.forBucket(scope);
        }
        if (response.status() != ResponseStatus.SUCCESS) {
            throw new CouchbaseException("Failed to " + action + "; response status=" + (Object)((Object)response.status()) + "; response body=" + content);
        }
    }

    protected CoreEnvironment environment() {
        return this.core.context().environment();
    }
}

