/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.eventing;

import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.EventingErrorContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.io.netty.NonChunkedHttpMessageHandler;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.service.ServiceType;

public class NonChunkedEventingMessageHandler
extends NonChunkedHttpMessageHandler {
    public NonChunkedEventingMessageHandler(BaseEndpoint endpoint) {
        super(endpoint, ServiceType.EVENTING);
    }

    @Override
    protected Exception failRequestWith(HttpResponseStatus status, String content, NonChunkedHttpRequest<Response> request) {
        EventingErrorContext errorContext = new EventingErrorContext(HttpProtocol.decodeStatus(status), request.context(), status.code());
        return new CouchbaseException("Unknown eventing error: " + content, errorContext);
    }
}

