/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;

@Stability.Internal
public class TracingUtils {
    private TracingUtils() {
    }

    public static void setCommonDispatchSpanAttributes(RequestSpan span, String localId, String localHost, int localPort, String remoteHost, int remotePort, String operationId) {
        span.attribute("db.system", "couchbase");
        span.attribute("net.transport", "IP.TCP");
        span.attribute("db.couchbase.local_id", localId);
        if (localHost != null) {
            span.attribute("net.host.name", localHost);
        }
        if (localPort != 0) {
            span.attribute("net.host.port", localPort);
        }
        if (remoteHost != null) {
            span.attribute("net.peer.name", remoteHost);
        }
        if (remotePort != 0) {
            span.attribute("net.peer.port", remotePort);
        }
        if (operationId != null) {
            span.attribute("db.couchbase.operation_id", operationId);
        }
    }

    public static void setNumericOperationId(RequestSpan span, long operationId) {
        span.attribute("db.couchbase.operation_id", operationId);
    }

    public static void setServerDurationAttribute(RequestSpan span, long serverDuration) {
        if (serverDuration > 0L) {
            span.attribute("db.couchbase.server_duration", serverDuration);
        }
    }
}

