/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbStrings;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCodeAndMessage {
    private final int code;
    private final String message;
    @JsonAnySetter
    private final Map<String, Object> context = new HashMap<String, Object>();
    private static final Pattern plaintextErrorPattern = Pattern.compile("(?<errorCode>\\d+):(?<message>.+)");

    public ErrorCodeAndMessage(@JsonProperty(value="code") int code, @JsonProperty(value="msg") String message) {
        this.code = code;
        this.message = CbStrings.nullToEmpty(message);
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Map<String, Object> context() {
        return Collections.unmodifiableMap(this.context);
    }

    public String toString() {
        return this.code + " " + this.message + (!this.context.isEmpty() ? " Context: " + this.context : "");
    }

    @Stability.Internal
    public static List<ErrorCodeAndMessage> fromJsonArray(byte[] jsonArray) {
        return ErrorCodeAndMessage.from(jsonArray);
    }

    private static List<ErrorCodeAndMessage> fromPlaintext(byte[] errorBytes) {
        String error = new String(errorBytes, StandardCharsets.UTF_8).trim();
        Matcher m = plaintextErrorPattern.matcher(error = ErrorCodeAndMessage.translateLegacyAnalyticsErrorCodes(error));
        if (m.matches()) {
            return CbCollections.listOf(new ErrorCodeAndMessage(Integer.parseInt(m.group("errorCode")), m.group("message")));
        }
        return CbCollections.listOf(new ErrorCodeAndMessage(0, "Failed to decode error: " + error));
    }

    private static String translateLegacyAnalyticsErrorCodes(String error) {
        if (error.startsWith("CBAS") || error.startsWith("ASX")) {
            return error.replace("CBAS0026", "24055").replace("CBAS0027", "24006").replace("ASX1063", "24034").replace("CBAS0062", "24001").replace("CBAS0063", "24001");
        }
        return error;
    }

    @Stability.Internal
    public static List<ErrorCodeAndMessage> from(byte[] content) {
        JsonNode node;
        try {
            node = Mapper.decodeIntoTree(content);
        }
        catch (Exception notJson) {
            return ErrorCodeAndMessage.fromPlaintext(content);
        }
        try {
            if (node.isArray()) {
                return Collections.unmodifiableList(Mapper.convertValue((Object)node, new TypeReference<List<ErrorCodeAndMessage>>(){}));
            }
            if (node.isObject()) {
                return CbCollections.listOf(Mapper.convertValue((Object)node, ErrorCodeAndMessage.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CbCollections.listOf(new ErrorCodeAndMessage(0, "Failed to decode errors: " + new String(content, StandardCharsets.UTF_8)));
    }
}

