/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.EmptyHttpHeaders;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpResponse;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaders;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.endpoint.http.CoreHttpTimeoutHelper;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

@Stability.Internal
public class CoreHttpRequest
extends BaseRequest<CoreHttpResponse>
implements NonChunkedHttpRequest<CoreHttpResponse> {
    private final RequestTarget target;
    private final HttpMethod method;
    private final CoreHttpPath path;
    private final String queryString;
    private final ByteBuf content;
    private final HttpHeaders headers;
    private final boolean idempotent;
    private final AtomicBoolean executed = new AtomicBoolean();

    public static Builder builder(CoreCommonOptions options, CoreContext coreContext, HttpMethod method, CoreHttpPath path, RequestTarget target) {
        return new Builder(options, coreContext, target, method, path);
    }

    private CoreHttpRequest(Builder builder, RequestSpan span, Duration timeout, RetryStrategy retry) {
        super(timeout, builder.coreContext, retry, span);
        this.target = builder.target;
        this.method = builder.method;
        this.path = builder.path;
        this.queryString = builder.queryString;
        this.content = builder.content;
        this.headers = builder.headers;
        this.idempotent = CbObjects.defaultIfNull(builder.idempotent, this.method == HttpMethod.GET);
        if (span != null) {
            span.attribute("db.couchbase.service", CbTracing.getTracingId(this.target.serviceType()));
            span.attribute("db.operation", builder.method + " " + builder.path.format());
        }
    }

    public CompletableFuture<CoreHttpResponse> exec(Core core) {
        if (!this.executed.compareAndSet(false, true)) {
            throw new IllegalStateException("This method may only be called once.");
        }
        core.send(this);
        return this.response().whenComplete((r, t) -> this.context().logicallyComplete());
    }

    @Override
    public FullHttpRequest encode() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, this.method, this.pathAndQueryString(), this.content);
        request.headers().add(this.headers);
        this.context().authenticator().authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public CoreHttpResponse decode(FullHttpResponse response, HttpChannelContext channelContext) {
        byte[] content = ByteBufUtil.getBytes(response.content());
        return new CoreHttpResponse(HttpProtocol.decodeStatus(response.status()), content, response.status().code(), channelContext, this.context());
    }

    @Override
    public ServiceType serviceType() {
        return this.target.serviceType();
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }

    @Override
    public NodeIdentifier target() {
        return this.target.nodeIdentifier();
    }

    @Override
    public String bucket() {
        return this.target.bucketName();
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("method", this.method.toString());
        ctx.put("path", RedactableArgument.redactMeta(this.pathAndQueryString()));
        if (this.target() != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target().address()));
        }
        if (this.bucket() != null) {
            ctx.put("bucket", RedactableArgument.redactMeta(this.bucket()));
        }
        return ctx;
    }

    private String pathAndQueryString() {
        return this.queryString.isEmpty() ? this.path.format() : this.path.format() + "?" + this.queryString;
    }

    public String toString() {
        return "CoreHttpRequest{serviceContext=" + this.serviceContext() + ",headers=" + this.headers + '}';
    }

    @Stability.Internal
    public static class Builder {
        private static final ByteBuf EMPTY_BYTE_BUF = Unpooled.buffer(0, 0);
        private final CoreCommonOptions options;
        private final CoreContext coreContext;
        private final RequestTarget target;
        private final HttpMethod method;
        private final CoreHttpPath path;
        private String queryString = "";
        private ByteBuf content = EMPTY_BYTE_BUF;
        private HttpHeaders headers = EmptyHttpHeaders.INSTANCE;
        private String spanName;
        private Boolean idempotent;

        public Builder(CoreCommonOptions options, CoreContext coreContext, RequestTarget target, HttpMethod method, CoreHttpPath path) {
            this.options = Objects.requireNonNull(options);
            this.coreContext = Objects.requireNonNull(coreContext);
            this.target = Objects.requireNonNull(target);
            this.method = Objects.requireNonNull(method);
            this.path = Objects.requireNonNull(path);
        }

        public static UrlQueryStringBuilder newForm() {
            return UrlQueryStringBuilder.createForUrlSafeNames();
        }

        public static UrlQueryStringBuilder newQueryString() {
            return UrlQueryStringBuilder.createForUrlSafeNames();
        }

        public Builder trace(String spanName) {
            this.spanName = spanName;
            return this;
        }

        public Builder header(CharSequence name, Object value) {
            if (this.headers == EmptyHttpHeaders.INSTANCE) {
                this.headers = new DefaultHttpHeaders();
            }
            this.headers.add(name, value);
            return this;
        }

        public Builder idempotent(boolean idempotent) {
            this.idempotent = idempotent;
            return this;
        }

        public Builder queryString(UrlQueryStringBuilder queryString) {
            this.queryString = queryString.build();
            return this;
        }

        public Builder form(UrlQueryStringBuilder formData) {
            return this.content(formData.build().getBytes(StandardCharsets.UTF_8), HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
        }

        public Builder json(byte[] content) {
            return this.content(content, HttpHeaderValues.APPLICATION_JSON);
        }

        public Builder content(byte[] content, CharSequence contentType) {
            this.content = Unpooled.wrappedBuffer(content);
            return this.header(HttpHeaderNames.CONTENT_TYPE, contentType).header(HttpHeaderNames.CONTENT_LENGTH, content.length);
        }

        public CoreHttpRequest build() {
            RequestSpan span = this.spanName == null ? null : CbTracing.newSpan(this.coreContext.environment().requestTracer(), this.spanName, (RequestSpan)this.options.parentSpan().orElse(null));
            return new CoreHttpRequest(this, span, CoreHttpTimeoutHelper.resolveTimeout(this.coreContext, this.target.serviceType(), this.options.timeout()), this.options.retryStrategy().orElse(null));
        }

        public CompletableFuture<CoreHttpResponse> exec(Core core) {
            return this.build().exec(core);
        }
    }
}

