/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.view;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpResponse;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.ScopedRequest;
import com.couchbase.client.core.msg.view.GenericViewResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

public class GenericViewRequest
extends BaseRequest<GenericViewResponse>
implements NonChunkedHttpRequest<GenericViewResponse>,
ScopedRequest {
    private final Supplier<FullHttpRequest> httpRequest;
    private final boolean idempotent;
    private final String bucket;

    public GenericViewRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Supplier<FullHttpRequest> requestSupplier, boolean idempotent, String bucket, RequestSpan span) {
        super(timeout, ctx, retryStrategy, span);
        this.httpRequest = Objects.requireNonNull(requestSupplier);
        this.idempotent = idempotent;
        this.bucket = Objects.requireNonNull(bucket);
        if (span != null) {
            span.setAttribute("db.couchbase.service", "views");
            span.setAttribute("db.name", bucket);
            FullHttpRequest request = requestSupplier.get();
            span.setAttribute("db.operation", request.method().toString() + " " + request.uri());
        }
    }

    @Override
    public GenericViewResponse decode(FullHttpResponse response, HttpChannelContext context) {
        byte[] dst = ByteBufUtil.getBytes(response.content());
        return new GenericViewResponse(HttpProtocol.decodeStatus(response.status()), dst);
    }

    @Override
    public FullHttpRequest encode() {
        FullHttpRequest request = this.httpRequest.get();
        this.context().authenticator().authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.VIEWS;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }
}

