/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.manager;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.manager.BaseManagerRequest;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

public class GenericManagerRequest
extends BaseManagerRequest<GenericManagerResponse> {
    private final Supplier<FullHttpRequest> requestSupplier;
    private final boolean idempotent;

    public GenericManagerRequest(CoreContext ctx, Supplier<FullHttpRequest> requestSupplier, boolean idempotent, RequestSpan span) {
        this(ctx.environment().timeoutConfig().managementTimeout(), ctx, ctx.environment().retryStrategy(), requestSupplier, idempotent, span);
    }

    public GenericManagerRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Supplier<FullHttpRequest> requestSupplier, boolean idempotent, RequestSpan span) {
        super(timeout, ctx, retryStrategy, span);
        this.requestSupplier = Objects.requireNonNull(requestSupplier);
        this.idempotent = idempotent;
        if (span != null) {
            span.setAttribute("db.couchbase.service", "management");
            FullHttpRequest request = requestSupplier.get();
            span.setAttribute("db.operation", request.method().toString() + " " + request.uri());
        }
    }

    @Override
    public GenericManagerResponse decode(HttpResponse response, byte[] content) {
        return new GenericManagerResponse(HttpProtocol.decodeStatus(response.status()), content, response.status().code());
    }

    @Override
    public FullHttpRequest encode() {
        FullHttpRequest request = this.requestSupplier.get();
        this.context().authenticator().authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }
}

