/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.query;

import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DmlFailureException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexFailureException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.ParsingFailureException;
import com.couchbase.client.core.error.PlanningFailureException;
import com.couchbase.client.core.error.PreparedStatementFailureException;
import com.couchbase.client.core.error.context.QueryErrorContext;
import com.couchbase.client.core.io.netty.chunk.BaseChunkResponseParser;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class QueryChunkResponseParser
extends BaseChunkResponseParser<QueryChunkHeader, QueryChunkRow, QueryChunkTrailer> {
    private static final List<Integer> PREPARED_ERROR_CODES = Arrays.asList(4040, 4050, 4060, 4070, 4080, 4090);
    private static final List<Integer> RETRYABLE_PREPARED_ERROR_CODES = Arrays.asList(4040, 4050, 4070);
    private String requestId;
    private Optional<byte[]> signature;
    private Optional<String> clientContextId;
    private Optional<String> prepared;
    private String status;
    private byte[] metrics;
    private byte[] warnings;
    private byte[] errors;
    private byte[] profile;
    private final JsonStreamParser.Builder parserBuilder = JsonStreamParser.builder().doOnValue("/requestID", v -> {
        this.requestId = v.readString();
    }).doOnValue("/signature", v -> {
        this.signature = Optional.of(v.readBytes());
    }).doOnValue("/clientContextID", v -> {
        this.clientContextId = Optional.of(v.readString());
    }).doOnValue("/prepared", v -> {
        this.prepared = Optional.of(v.readString());
    }).doOnValue("/results/-", v -> {
        this.markHeaderComplete();
        this.emitRow(new QueryChunkRow(v.readBytes()));
    }).doOnValue("/status", v -> {
        this.markHeaderComplete();
        this.status = v.readString();
    }).doOnValue("/metrics", v -> {
        this.metrics = v.readBytes();
    }).doOnValue("/profile", v -> {
        this.profile = v.readBytes();
    }).doOnValue("/errors", v -> {
        this.errors = v.readBytes();
        this.failRows(this.errorsToThrowable(this.errors));
    }).doOnValue("/warnings", v -> {
        this.warnings = v.readBytes();
    });

    @Override
    protected void doCleanup() {
        this.requestId = null;
        this.signature = Optional.empty();
        this.clientContextId = Optional.empty();
        this.prepared = Optional.empty();
        this.status = null;
        this.metrics = null;
        this.warnings = null;
        this.errors = null;
        this.profile = null;
    }

    @Override
    protected JsonStreamParser.Builder parserBuilder() {
        return this.parserBuilder;
    }

    @Override
    public Optional<QueryChunkHeader> header(boolean lastChunk) {
        return this.isHeaderComplete() ? Optional.of(new QueryChunkHeader(this.requestId, this.clientContextId, this.signature, this.prepared)) : Optional.empty();
    }

    @Override
    public Optional<CouchbaseException> error() {
        return Optional.ofNullable(this.errors).map(this::errorsToThrowable);
    }

    private CouchbaseException errorsToThrowable(byte[] bytes) {
        List<ErrorCodeAndMessage> errors = bytes.length == 0 ? Collections.emptyList() : ErrorCodeAndMessage.fromJsonArray(bytes);
        QueryErrorContext errorContext = new QueryErrorContext(this.requestContext(), errors);
        if (errors.size() >= 1) {
            int code = errors.get(0).code();
            String message = errors.get(0).message();
            if (code == 3000) {
                return new ParsingFailureException(errorContext);
            }
            if (PREPARED_ERROR_CODES.contains(code)) {
                return new PreparedStatementFailureException(errorContext, RETRYABLE_PREPARED_ERROR_CODES.contains(code));
            }
            if (code == 4300 && message.matches("^.*index .*already exist.*")) {
                return new IndexExistsException(errorContext);
            }
            if (code >= 4000 && code < 5000) {
                return new PlanningFailureException(errorContext);
            }
            if (code == 12004 || code == 12016 || code == 5000 && message.matches("^.*index .+ not found.*")) {
                return new IndexNotFoundException(errorContext);
            }
            if (code == 5000 && message.matches("^.*Index .*already exist.*")) {
                return new IndexExistsException(errorContext);
            }
            if (code >= 5000 && code < 6000) {
                return new InternalServerFailureException(errorContext);
            }
            if (code == 12009 && message.contains("CAS mismatch")) {
                return new CasMismatchException(errorContext);
            }
            if (code == 12009) {
                return new DmlFailureException(errorContext);
            }
            if (code >= 10000 && code < 11000) {
                return new AuthenticationFailureException("Could not authenticate query", errorContext, null);
            }
            if (code >= 12000 && code < 13000 || code >= 14000 && code < 15000) {
                return new IndexFailureException(errorContext);
            }
        }
        return new CouchbaseException("Unknown query error", errorContext);
    }

    @Override
    public void signalComplete() {
        this.completeRows();
        this.completeTrailer(new QueryChunkTrailer(this.status, Optional.ofNullable(this.metrics), Optional.ofNullable(this.warnings), Optional.ofNullable(this.errors), Optional.ofNullable(this.profile)));
    }
}

