/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;

@Stability.Internal
public class TracingUtils {
    private TracingUtils() {
    }

    public static void setCommonDispatchSpanAttributes(RequestSpan span, String localId, String localHost, int localPort, String remoteHost, int remotePort, String operationId) {
        span.setAttribute("db.system", "couchbase");
        span.setAttribute("net.transport", "IP.TCP");
        span.setAttribute("db.couchbase.local_id", localId);
        if (localHost != null) {
            span.setAttribute("net.host.name", localHost);
        }
        if (localPort != 0) {
            span.setAttribute("net.host.port", localPort);
        }
        if (remoteHost != null) {
            span.setAttribute("net.peer.name", remoteHost);
        }
        if (remotePort != 0) {
            span.setAttribute("net.peer.port", remotePort);
        }
        if (operationId != null) {
            span.setAttribute("db.couchbase.operation_id", operationId);
        }
    }

    public static void setNumericOperationId(RequestSpan span, long operationId) {
        span.setAttribute("db.couchbase.operation_id", operationId);
    }

    public static void setServerDurationAttribute(RequestSpan span, long serverDuration) {
        if (serverDuration > 0L) {
            span.setAttribute("db.couchbase.server_duration", serverDuration);
        }
    }
}

