/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.epoll.Epoll;
import com.couchbase.client.core.deps.io.netty.channel.epoll.EpollEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueue;
import com.couchbase.client.core.deps.io.netty.channel.kqueue.KQueueEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.couchbase.client.core.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.couchbase.client.core.env.ExternalSupplier;
import com.couchbase.client.core.env.OwnedSupplier;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class IoEnvironment {
    public static final boolean DEFAULT_NATIVE_IO_ENABLED = true;
    @Stability.Internal
    public static final int DEFAULT_EVENT_LOOP_THREAD_COUNT;
    private final boolean nativeIoEnabled;
    private final int eventLoopThreadCount;
    private final Supplier<EventLoopGroup> managerEventLoopGroup;
    private final Supplier<EventLoopGroup> kvEventLoopGroup;
    private final Supplier<EventLoopGroup> queryEventLoopGroup;
    private final Supplier<EventLoopGroup> analyticsEventLoopGroup;
    private final Supplier<EventLoopGroup> searchEventLoopGroup;
    private final Supplier<EventLoopGroup> viewEventLoopGroup;

    public static IoEnvironment create() {
        return IoEnvironment.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder managerEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().managerEventLoopGroup(eventLoopGroup);
    }

    public static Builder kvEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().kvEventLoopGroup(eventLoopGroup);
    }

    public static Builder queryEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().queryEventLoopGroup(eventLoopGroup);
    }

    public static Builder analyticsEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().analyticsEventLoopGroup(eventLoopGroup);
    }

    public static Builder searchEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().searchEventLoopGroup(eventLoopGroup);
    }

    public static Builder viewEventLoopGroup(EventLoopGroup eventLoopGroup) {
        return IoEnvironment.builder().viewEventLoopGroup(eventLoopGroup);
    }

    public static Builder eventLoopThreadCount(int eventLoopThreadCount) {
        return IoEnvironment.builder().eventLoopThreadCount(eventLoopThreadCount);
    }

    public static Builder enableNativeIo(boolean nativeIoEnabled) {
        return IoEnvironment.builder().enableNativeIo(nativeIoEnabled);
    }

    @Stability.Volatile
    Map<String, Object> exportAsMap() {
        LinkedHashMap<String, Object> export = new LinkedHashMap<String, Object>();
        export.put("nativeIoEnabled", this.nativeIoEnabled);
        export.put("eventLoopThreadCount", this.eventLoopThreadCount);
        HashSet<String> eventLoopGroups = new HashSet<String>();
        eventLoopGroups.add(this.managerEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.kvEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.queryEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.analyticsEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.searchEventLoopGroup.get().getClass().getSimpleName());
        eventLoopGroups.add(this.viewEventLoopGroup.get().getClass().getSimpleName());
        export.put("eventLoopGroups", eventLoopGroups);
        return export;
    }

    private IoEnvironment(Builder builder) {
        this.nativeIoEnabled = builder.nativeIoEnabled;
        this.eventLoopThreadCount = builder.eventLoopThreadCount;
        OwnedSupplier<EventLoopGroup> httpDefaultGroup = null;
        if (builder.queryEventLoopGroup == null || builder.analyticsEventLoopGroup == null || builder.searchEventLoopGroup == null || builder.viewEventLoopGroup == null) {
            httpDefaultGroup = IoEnvironment.createEventLoopGroup(this.nativeIoEnabled, this.eventLoopThreadCount, "cb-io-http");
        }
        this.managerEventLoopGroup = builder.managerEventLoopGroup == null ? IoEnvironment.createEventLoopGroup(this.nativeIoEnabled, 1, "cb-io-manager") : builder.managerEventLoopGroup;
        this.sanityCheckEventLoop(this.managerEventLoopGroup);
        this.kvEventLoopGroup = builder.kvEventLoopGroup == null ? IoEnvironment.createEventLoopGroup(this.nativeIoEnabled, this.eventLoopThreadCount, "cb-io-kv") : builder.kvEventLoopGroup;
        this.sanityCheckEventLoop(this.kvEventLoopGroup);
        this.queryEventLoopGroup = builder.queryEventLoopGroup == null ? httpDefaultGroup : builder.queryEventLoopGroup;
        this.sanityCheckEventLoop(this.queryEventLoopGroup);
        this.analyticsEventLoopGroup = builder.analyticsEventLoopGroup == null ? httpDefaultGroup : builder.queryEventLoopGroup;
        this.sanityCheckEventLoop(this.analyticsEventLoopGroup);
        this.searchEventLoopGroup = builder.searchEventLoopGroup == null ? httpDefaultGroup : builder.searchEventLoopGroup;
        this.sanityCheckEventLoop(this.searchEventLoopGroup);
        this.viewEventLoopGroup = builder.viewEventLoopGroup == null ? httpDefaultGroup : builder.viewEventLoopGroup;
        this.sanityCheckEventLoop(this.viewEventLoopGroup);
    }

    private void sanityCheckEventLoop(Supplier<EventLoopGroup> group) {
        if (!this.nativeIoEnabled && !(group.get() instanceof NioEventLoopGroup)) {
            throw InvalidArgumentException.fromMessage("Native IO is disabled and the EventLoopGroup is not a NioEventLoopGroup");
        }
    }

    public Supplier<EventLoopGroup> managerEventLoopGroup() {
        return this.managerEventLoopGroup;
    }

    public Supplier<EventLoopGroup> kvEventLoopGroup() {
        return this.kvEventLoopGroup;
    }

    public Supplier<EventLoopGroup> queryEventLoopGroup() {
        return this.queryEventLoopGroup;
    }

    public Supplier<EventLoopGroup> analyticsEventLoopGroup() {
        return this.analyticsEventLoopGroup;
    }

    public Supplier<EventLoopGroup> searchEventLoopGroup() {
        return this.searchEventLoopGroup;
    }

    public Supplier<EventLoopGroup> viewEventLoopGroup() {
        return this.viewEventLoopGroup;
    }

    public boolean nativeIoEnabled() {
        return this.nativeIoEnabled;
    }

    public Mono<Void> shutdown(Duration timeout) {
        return Flux.merge((Publisher[])new Publisher[]{IoEnvironment.shutdownGroup(this.managerEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.kvEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.queryEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.analyticsEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.searchEventLoopGroup, timeout), IoEnvironment.shutdownGroup(this.viewEventLoopGroup, timeout)}).then();
    }

    private static Mono<Void> shutdownGroup(Supplier<EventLoopGroup> groupSupplier, Duration timeout) {
        EventLoopGroup group;
        if (groupSupplier instanceof OwnedSupplier && !(group = groupSupplier.get()).isShutdown() && !group.isShuttingDown()) {
            return Mono.create(sink -> group.shutdownGracefully(0L, timeout.toMillis(), TimeUnit.MILLISECONDS).addListener(future -> {
                if (future.isSuccess()) {
                    sink.success();
                } else {
                    sink.error(future.cause());
                }
            }));
        }
        return Mono.empty();
    }

    private static OwnedSupplier<EventLoopGroup> createEventLoopGroup(boolean nativeIoEnabled, int numThreads, String poolName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(poolName, true);
        if (nativeIoEnabled && Epoll.isAvailable()) {
            return new OwnedSupplier<EventLoopGroup>(new EpollEventLoopGroup(numThreads, threadFactory));
        }
        if (nativeIoEnabled && KQueue.isAvailable()) {
            return new OwnedSupplier<EventLoopGroup>(new KQueueEventLoopGroup(numThreads, threadFactory));
        }
        return new OwnedSupplier<EventLoopGroup>(new NioEventLoopGroup(numThreads, threadFactory));
    }

    private static int fairThreadCount() {
        int cores = Runtime.getRuntime().availableProcessors() / 2;
        cores = Math.max(cores, 2);
        cores = Math.min(cores, 8);
        return cores;
    }

    static {
        String samplingProperty = "com.couchbase.client.core.deps.io.netty.leakDetection.samplingInterval";
        long defaultSamplingInterval = 65536L;
        if (CbCollections.isNullOrEmpty(System.getProperty("com.couchbase.client.core.deps.io.netty.leakDetection.samplingInterval"))) {
            System.setProperty("com.couchbase.client.core.deps.io.netty.leakDetection.samplingInterval", Long.toString(65536L));
        }
        DEFAULT_EVENT_LOOP_THREAD_COUNT = IoEnvironment.fairThreadCount();
    }

    public static class Builder {
        private boolean nativeIoEnabled = true;
        private Supplier<EventLoopGroup> managerEventLoopGroup = null;
        private Supplier<EventLoopGroup> kvEventLoopGroup = null;
        private Supplier<EventLoopGroup> queryEventLoopGroup = null;
        private Supplier<EventLoopGroup> analyticsEventLoopGroup = null;
        private Supplier<EventLoopGroup> searchEventLoopGroup = null;
        private Supplier<EventLoopGroup> viewEventLoopGroup = null;
        private int eventLoopThreadCount = DEFAULT_EVENT_LOOP_THREAD_COUNT;

        public Builder managerEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.managerEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder kvEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.kvEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder queryEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.queryEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder analyticsEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.analyticsEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder searchEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.searchEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        public Builder viewEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.viewEventLoopGroup = Builder.checkEventLoopGroup(eventLoopGroup);
            return this;
        }

        private static Supplier<EventLoopGroup> checkEventLoopGroup(EventLoopGroup eventLoopGroup) {
            return new ExternalSupplier<EventLoopGroup>(Validators.notNull(eventLoopGroup, "EventLoopGroup"));
        }

        public Builder enableNativeIo(boolean nativeIoEnabled) {
            this.nativeIoEnabled = nativeIoEnabled;
            return this;
        }

        public Builder eventLoopThreadCount(int eventLoopThreadCount) {
            if (eventLoopThreadCount < 1) {
                throw InvalidArgumentException.fromMessage("EventLoopThreadCount cannot be smaller than 1");
            }
            this.eventLoopThreadCount = eventLoopThreadCount;
            return this;
        }

        @Stability.Internal
        public IoEnvironment build() {
            return new IoEnvironment(this);
        }
    }
}

