/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.cnc.AbstractContext;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class WaitUntilReadyContext
extends AbstractContext {
    private final Set<ServiceType> serviceTypes;
    private final Duration timeout;
    private final ClusterState desiredState;
    private final Optional<String> bucketName;
    private final Map<ServiceType, List<EndpointDiagnostics>> diagnostics;

    public WaitUntilReadyContext(Set<ServiceType> serviceTypes, Duration timeout, ClusterState desiredState, Optional<String> bucketName, Map<ServiceType, List<EndpointDiagnostics>> diagnostics) {
        this.diagnostics = diagnostics;
        this.serviceTypes = serviceTypes;
        this.timeout = timeout;
        this.desiredState = desiredState;
        this.bucketName = bucketName;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        input.put("desiredState", (Object)this.desiredState);
        input.put("currentState", (Object)DiagnosticsResult.aggregateClusterState(this.diagnostics.values()));
        input.put("checkedServices", this.serviceTypes);
        input.put("timeoutMs", this.timeout.toMillis());
        this.bucketName.ifPresent(b -> input.put("bucket", b));
        LinkedHashMap services = new LinkedHashMap();
        for (Map.Entry<ServiceType, List<EndpointDiagnostics>> service : this.diagnostics.entrySet()) {
            services.put(service.getKey().ident(), service.getValue().stream().map(EndpointDiagnostics::toMap).collect(Collectors.toList()));
        }
        input.put("services", services);
    }
}

