/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.IncrementResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class IncrementRequest
extends BaseKeyValueRequest<IncrementResponse>
implements SyncDurabilityRequest {
    public static final int COUNTER_NOT_EXISTS_EXPIRY = -1;
    private final long delta;
    private final Optional<Long> initial;
    private final long expiry;
    private final Optional<DurabilityLevel> syncReplicationType;

    public IncrementRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, long delta, Optional<Long> initial, long expiration, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        if (initial.isPresent() && initial.get() < 0L) {
            throw InvalidArgumentException.fromMessage("The initial needs to be >= 0");
        }
        this.delta = delta;
        this.initial = initial;
        this.expiry = expiration;
        this.syncReplicationType = syncReplicationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        ByteBuf flexibleExtras = null;
        try {
            ByteBuf request;
            key = this.encodedKeyWithCollection(alloc, ctx);
            extras = alloc.buffer(20);
            extras.writeLong(this.delta);
            if (this.initial.isPresent()) {
                extras.writeLong(this.initial.get());
                extras.writeInt((int)this.expiry);
            } else {
                extras.writeLong(0L);
                extras.writeInt(-1);
            }
            if (this.syncReplicationType.isPresent()) {
                if (!ctx.syncReplicationEnabled()) throw new DurabilityLevelNotAvailableException(KeyValueErrorContext.incompleteRequest(this));
                flexibleExtras = MemcacheProtocol.flexibleSyncReplication(alloc, this.syncReplicationType.get(), this.timeout(), this.context());
                request = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.INCREMENT, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), flexibleExtras, extras, key, MemcacheProtocol.noBody());
            } else {
                request = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.INCREMENT, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras, key, MemcacheProtocol.noBody());
            }
            byteBuf = request;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            ReferenceCountUtil.release(flexibleExtras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        ReferenceCountUtil.release(flexibleExtras);
        return byteBuf;
    }

    @Override
    public IncrementResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        return new IncrementResponse(MemcacheProtocol.decodeStatus(response), MemcacheProtocol.body(response).map(ByteBuf::readLong).orElse(0L), MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()));
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }
}

