/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.kv.AppendResponse;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class AppendRequest
extends BaseKeyValueRequest<AppendResponse>
implements SyncDurabilityRequest {
    private final byte[] content;
    private final long cas;
    private final Optional<DurabilityLevel> syncReplicationType;

    public AppendRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, byte[] content, long cas, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.content = content;
        this.cas = cas;
        this.syncReplicationType = syncReplicationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf content = null;
        ByteBuf flexibleExtras = null;
        try {
            ByteBuf request;
            key = this.encodedKeyWithCollection(alloc, ctx);
            byte datatype = 0;
            CompressionConfig config = ctx.compressionConfig();
            if (config != null && config.enabled() && this.content.length >= config.minSize()) {
                ByteBuf maybeCompressed = MemcacheProtocol.tryCompression(this.content, config.minRatio());
                if (maybeCompressed != null) {
                    datatype = (byte)(datatype | MemcacheProtocol.Datatype.SNAPPY.datatype());
                    content = maybeCompressed;
                } else {
                    content = Unpooled.wrappedBuffer(this.content);
                }
            } else {
                content = Unpooled.wrappedBuffer(this.content);
            }
            if (this.syncReplicationType.isPresent()) {
                if (!ctx.syncReplicationEnabled()) throw new DurabilityLevelNotAvailableException(KeyValueErrorContext.incompleteRequest(this));
                flexibleExtras = MemcacheProtocol.flexibleSyncReplication(alloc, this.syncReplicationType.get(), this.timeout(), this.context());
                request = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.APPEND, datatype, this.partition(), opaque, this.cas, flexibleExtras, MemcacheProtocol.noExtras(), key, content);
            } else {
                request = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.APPEND, datatype, this.partition(), opaque, this.cas, MemcacheProtocol.noExtras(), key, content);
            }
            byteBuf = request;
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(content);
            ReferenceCountUtil.release(flexibleExtras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(content);
        ReferenceCountUtil.release(flexibleExtras);
        return byteBuf;
    }

    @Override
    public AppendResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        return new AppendResponse(MemcacheProtocol.decodeStatus(response), MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()));
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }
}

