/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class CollectionNotFoundException
extends CouchbaseException {
    private final String collectionName;

    public CollectionNotFoundException(String collectionName) {
        super("Collection [" + RedactableArgument.redactMeta(collectionName) + "] not found.");
        this.collectionName = Objects.requireNonNull(collectionName);
    }

    public static CollectionNotFoundException forCollection(String collectionName) {
        return new CollectionNotFoundException(collectionName);
    }

    public String collectionName() {
        return this.collectionName;
    }
}

