/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class EndpointDiagnostics {
    private final ServiceType type;
    private final EndpointState state;
    private final String local;
    private final String remote;
    private final Optional<Long> lastActivityUs;
    private final Optional<String> id;
    private final Optional<String> namespace;

    @Stability.Internal
    public EndpointDiagnostics(ServiceType type, EndpointState state, String local, String remote, Optional<String> namespace, Optional<Long> lastActivityUs, Optional<String> id) {
        this.type = type;
        this.state = state;
        this.id = id;
        this.local = local;
        this.remote = remote;
        this.lastActivityUs = lastActivityUs;
        this.namespace = namespace;
    }

    public ServiceType type() {
        return this.type;
    }

    public Optional<String> id() {
        return this.id;
    }

    public String local() {
        return this.local;
    }

    public String remote() {
        return this.remote;
    }

    public Optional<Duration> lastActivity() {
        return this.lastActivityUs.map(a -> Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos((long)a)));
    }

    public EndpointState state() {
        return this.state;
    }

    public Optional<String> namespace() {
        return this.namespace;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.remote != null) {
            map.put("remote", this.remote);
        }
        if (this.local != null) {
            map.put("local", this.local);
        }
        map.put("state", this.state().toString().toLowerCase());
        this.lastActivityUs.ifPresent(a -> map.put("last_activity_us", a));
        this.id.ifPresent(id -> map.put("id", id));
        this.namespace.ifPresent(n -> map.put("namespace", n));
        return map;
    }

    public String toString() {
        return "EndpointDiagnostics{type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", local='" + this.local + '\'' + ", remote='" + this.remote + '\'' + ", lastActivityUs=" + this.lastActivityUs + ", id='" + this.id + '\'' + ", namespace=" + this.namespace + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointDiagnostics that = (EndpointDiagnostics)o;
        return this.type == that.type && this.state == that.state && Objects.equals(this.local, that.local) && Objects.equals(this.remote, that.remote) && Objects.equals(this.lastActivityUs, that.lastActivityUs) && Objects.equals(this.id, that.id) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.state, this.local, this.remote, this.lastActivityUs, this.id, this.namespace});
    }
}

