/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.config.BucketConfigUpdatedEvent;
import com.couchbase.client.core.cnc.events.config.BucketOpenRetriedEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapRefreshFailedEvent;
import com.couchbase.client.core.cnc.events.config.CollectionMapRefreshSucceededEvent;
import com.couchbase.client.core.cnc.events.config.ConfigIgnoredEvent;
import com.couchbase.client.core.cnc.events.config.GlobalConfigUpdatedEvent;
import com.couchbase.client.core.cnc.events.config.IndividualGlobalConfigLoadFailedEvent;
import com.couchbase.client.core.cnc.events.config.SeedNodesUpdatedEvent;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.BucketConfigParser;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.config.GlobalConfigParser;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.ProposedGlobalConfigContext;
import com.couchbase.client.core.config.loader.ClusterManagerBucketLoader;
import com.couchbase.client.core.config.loader.GlobalLoader;
import com.couchbase.client.core.config.loader.KeyValueBucketLoader;
import com.couchbase.client.core.config.refresher.ClusterManagerBucketRefresher;
import com.couchbase.client.core.config.refresher.GlobalRefresher;
import com.couchbase.client.core.config.refresher.KeyValueBucketRefresher;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.AlreadyShutdownException;
import com.couchbase.client.core.error.BucketNotFoundDuringLoadException;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.SeedNodeOutdatedException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.CollectionMap;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetCollectionIdRequest;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;
import reactor.util.retry.Retry;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final int DEFAULT_KV_PORT = 11210;
    private static final int DEFAULT_MANAGER_PORT = 8091;
    private static final int DEFAULT_KV_TLS_PORT = 11207;
    private static final int DEFAULT_MANAGER_TLS_PORT = 18091;
    private static final int MAX_PARALLEL_LOADERS = 5;
    private final Core core;
    private final EventBus eventBus;
    private final KeyValueBucketLoader keyValueLoader;
    private final ClusterManagerBucketLoader clusterManagerLoader;
    private final KeyValueBucketRefresher keyValueRefresher;
    private final ClusterManagerBucketRefresher clusterManagerRefresher;
    private final GlobalLoader globalLoader;
    private final GlobalRefresher globalRefresher;
    private final ReplayProcessor<ClusterConfig> configs = ReplayProcessor.cacheLast();
    private final FluxSink<ClusterConfig> configsSink = this.configs.sink();
    private final ClusterConfig currentConfig = new ClusterConfig();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CollectionMap collectionMap = new CollectionMap();
    private final AtomicBoolean alternateAddrChecked = new AtomicBoolean(false);
    private volatile boolean globalConfigLoadInProgress = false;
    private final AtomicInteger bucketConfigLoadInProgress = new AtomicInteger();
    private final AtomicInteger collectionMapRefreshInProgress = new AtomicInteger();
    private final AtomicReference<Set<SeedNode>> currentSeedNodes;
    private final ReplayProcessor<Set<SeedNode>> seedNodes = ReplayProcessor.cacheLast();
    private final FluxSink<Set<SeedNode>> seedNodesSink = this.seedNodes.sink();

    public DefaultConfigurationProvider(Core core, Set<SeedNode> seedNodes) {
        this.core = core;
        this.eventBus = core.context().environment().eventBus();
        this.currentSeedNodes = new AtomicReference<Set<SeedNode>>(CbCollections.copyToUnmodifiableSet(seedNodes));
        this.keyValueLoader = new KeyValueBucketLoader(core);
        this.clusterManagerLoader = new ClusterManagerBucketLoader(core);
        this.keyValueRefresher = new KeyValueBucketRefresher(this, core);
        this.clusterManagerRefresher = new ClusterManagerBucketRefresher(this, core);
        this.globalLoader = new GlobalLoader(core);
        this.globalRefresher = new GlobalRefresher(this, core);
        this.configsSink.next((Object)this.currentConfig);
    }

    @Override
    public CollectionMap collectionMap() {
        return this.collectionMap;
    }

    @Override
    public Flux<ClusterConfig> configs() {
        return this.configs;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig;
    }

    @Override
    public Flux<Set<SeedNode>> seedNodes() {
        return this.seedNodes;
    }

    @Override
    public Mono<Void> openBucket(String name) {
        return Mono.defer(() -> {
            if (!this.shutdown.get()) {
                this.bucketConfigLoadInProgress.incrementAndGet();
                boolean tls = this.core.context().environment().securityConfig().tlsEnabled();
                int kvPort = tls ? 11207 : 11210;
                int managerPort = tls ? 18091 : 8091;
                Optional<String> alternate = this.core.context().alternateAddress();
                return Flux.range((int)1, (int)Math.min(5, this.currentSeedNodes().size())).flatMap(index -> Flux.fromIterable(this.currentSeedNodes()).take((long)Math.min(index, this.currentSeedNodes().size())).last().flatMap(seed -> {
                    int mappedManagerPort;
                    int mappedKvPort;
                    NodeIdentifier identifier = new NodeIdentifier(seed.address(), seed.clusterManagerPort().orElse(8091));
                    AtomicReference alternatePorts = new AtomicReference();
                    Optional<String> alternateAddress = alternate.map(a -> this.mapAlternateAddress((String)a, (SeedNode)seed, tls, alternatePorts));
                    if (alternateAddress.isPresent()) {
                        Map ports = (Map)alternatePorts.get();
                        mappedKvPort = (Integer)ports.get((Object)ServiceType.KV);
                        mappedManagerPort = (Integer)ports.get((Object)ServiceType.MANAGER);
                    } else {
                        mappedKvPort = seed.kvPort().orElse(kvPort);
                        mappedManagerPort = seed.clusterManagerPort().orElse(managerPort);
                    }
                    return this.loadBucketConfigForSeed(identifier, mappedKvPort, mappedManagerPort, name, alternateAddress);
                }).retryWhen(Retry.from(companion -> companion.flatMap(rs -> {
                    Throwable f = rs.failure();
                    if (f instanceof ConfigException && f.getCause() instanceof RequestCanceledException && ((RequestCanceledException)f.getCause()).reason() == CancellationReason.TARGET_NODE_REMOVED || f instanceof BucketNotFoundDuringLoadException) {
                        Duration delay = f instanceof BucketNotFoundDuringLoadException ? Duration.ofMillis(500L) : Duration.ofMillis(1L);
                        this.eventBus.publish(new BucketOpenRetriedEvent(name, delay, this.core.context(), f));
                        return Mono.just((Object)rs.totalRetries()).delayElement(delay, this.core.context().environment().scheduler());
                    }
                    return Mono.error((Throwable)Exceptions.propagate((Throwable)rs.failure()));
                })))).take(1L).switchIfEmpty((Publisher)Mono.error((Throwable)new ConfigException("Could not locate a single bucket configuration for bucket: " + name))).map(ctx -> {
                    this.proposeBucketConfig((ProposedBucketConfigContext)ctx);
                    return ctx;
                }).then(this.registerRefresher(name)).doOnTerminate(this.bucketConfigLoadInProgress::decrementAndGet).onErrorResume(t -> this.closeBucketIgnoreShutdown(name).then(Mono.error((Throwable)t)));
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    protected Mono<ProposedBucketConfigContext> loadBucketConfigForSeed(NodeIdentifier identifier, int mappedKvPort, int mappedManagerPort, String name, Optional<String> alternateAddress) {
        return this.keyValueLoader.load(identifier, mappedKvPort, name, alternateAddress).onErrorResume(t -> {
            boolean removedWhileOpInFlight = t instanceof ConfigException && t.getCause() instanceof RequestCanceledException && ((RequestCanceledException)t.getCause()).reason() == CancellationReason.TARGET_NODE_REMOVED;
            boolean seedNodeOutdated = t instanceof SeedNodeOutdatedException;
            if (removedWhileOpInFlight || seedNodeOutdated) {
                return Mono.error((Throwable)t);
            }
            return this.clusterManagerLoader.load(identifier, mappedManagerPort, name, alternateAddress);
        });
    }

    private String mapAlternateAddress(String a, SeedNode seed, boolean tls, AtomicReference<Map<ServiceType, Integer>> alternatePorts) {
        ClusterConfig c = this.currentConfig;
        if (c.globalConfig() != null) {
            for (PortInfo pi : c.globalConfig().portInfos()) {
                if (!seed.address().equals(pi.hostname())) continue;
                alternatePorts.set(tls ? pi.alternateAddresses().get(a).sslServices() : pi.alternateAddresses().get(a).services());
                return pi.alternateAddresses().get(a).hostname();
            }
        }
        List nodeInfos = c.bucketConfigs().values().stream().flatMap(bc -> bc.nodes().stream()).collect(Collectors.toList());
        for (NodeInfo ni : nodeInfos) {
            if (!ni.hostname().equals(seed.address())) continue;
            alternatePorts.set(tls ? ni.alternateAddresses().get(a).sslServices() : ni.alternateAddresses().get(a).services());
            return ni.alternateAddresses().get(a).hostname();
        }
        return null;
    }

    @Override
    public Mono<Void> loadAndRefreshGlobalConfig() {
        return Mono.defer(() -> {
            if (!this.shutdown.get()) {
                this.globalConfigLoadInProgress = true;
                boolean tls = this.core.context().environment().securityConfig().tlsEnabled();
                int kvPort = tls ? 11207 : 11210;
                AtomicBoolean hasErrored = new AtomicBoolean();
                return Flux.range((int)1, (int)Math.min(5, this.currentSeedNodes().size())).flatMap(index -> Flux.fromIterable(this.currentSeedNodes()).take((long)Math.min(index, this.currentSeedNodes().size())).last().flatMap(seed -> {
                    long start = System.nanoTime();
                    NodeIdentifier identifier = new NodeIdentifier(seed.address(), seed.clusterManagerPort().orElse(8091));
                    return this.globalLoader.load(identifier, seed.kvPort().orElse(kvPort)).doOnError(throwable -> this.core.context().environment().eventBus().publish(new IndividualGlobalConfigLoadFailedEvent(Duration.ofNanos(System.nanoTime() - start), this.core.context(), (Throwable)throwable, seed.address())));
                }).retryWhen(Retry.from(companion -> companion.map(rs -> {
                    if (rs.failure() instanceof ConfigException && rs.failure().getCause() instanceof RequestCanceledException && ((RequestCanceledException)rs.failure().getCause()).reason() == CancellationReason.TARGET_NODE_REMOVED) {
                        return rs.totalRetries();
                    }
                    throw Exceptions.propagate((Throwable)rs.failure());
                }))).onErrorResume(throwable -> {
                    if (hasErrored.compareAndSet(false, true)) {
                        return Mono.error((Throwable)throwable);
                    }
                    return Mono.empty();
                })).take(1L).switchIfEmpty((Publisher)Mono.error((Throwable)new ConfigException("Could not locate a single global configuration"))).map(ctx -> {
                    this.proposeGlobalConfig((ProposedGlobalConfigContext)ctx);
                    return ctx;
                }).then(this.globalRefresher.start()).doOnTerminate(() -> {
                    this.globalConfigLoadInProgress = false;
                });
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    @Override
    public void proposeBucketConfig(ProposedBucketConfigContext ctx) {
        if (!this.shutdown.get()) {
            try {
                BucketConfig config = BucketConfigParser.parse(ctx.config(), this.core.context().environment(), ctx.origin());
                this.checkAndApplyConfig(config);
            }
            catch (Exception ex) {
                this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.PARSE_FAILURE, Optional.of(ex), Optional.of(ctx.config())));
            }
        } else {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.ALREADY_SHUTDOWN, Optional.empty(), Optional.of(ctx.config())));
        }
    }

    @Override
    public void proposeGlobalConfig(ProposedGlobalConfigContext ctx) {
        if (!this.shutdown.get()) {
            try {
                GlobalConfig config = GlobalConfigParser.parse(ctx.config(), ctx.origin());
                this.checkAndApplyConfig(config);
            }
            catch (Exception ex) {
                this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.PARSE_FAILURE, Optional.of(ex), Optional.of(ctx.config())));
            }
        } else {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.ALREADY_SHUTDOWN, Optional.empty(), Optional.of(ctx.config())));
        }
    }

    @Override
    public Mono<Void> closeBucket(String name) {
        return Mono.defer(() -> this.shutdown.get() ? Mono.error((Throwable)new AlreadyShutdownException()) : this.closeBucketIgnoreShutdown(name));
    }

    private Mono<Void> closeBucketIgnoreShutdown(String name) {
        return Mono.defer(() -> {
            this.currentConfig.deleteBucketConfig(name);
            this.pushConfig();
            return Mono.empty();
        }).then(this.keyValueRefresher.deregister(name)).then(this.clusterManagerRefresher.deregister(name));
    }

    @Override
    public Mono<Void> shutdown() {
        return Mono.defer(() -> {
            if (this.shutdown.compareAndSet(false, true)) {
                return Flux.fromIterable(this.currentConfig.bucketConfigs().values()).flatMap(bucketConfig -> this.closeBucketIgnoreShutdown(bucketConfig.name())).then(Mono.defer(this::disableAndClearGlobalConfig)).doOnTerminate(() -> {
                    this.pushConfig();
                    this.configsSink.complete();
                }).then(this.keyValueRefresher.shutdown()).then(this.clusterManagerRefresher.shutdown()).then(this.globalRefresher.shutdown());
            }
            return Mono.error((Throwable)new AlreadyShutdownException());
        });
    }

    private Mono<Void> disableAndClearGlobalConfig() {
        return this.globalRefresher.stop().then(Mono.defer(() -> {
            this.currentConfig.deleteGlobalConfig();
            return Mono.empty();
        }));
    }

    @Override
    public void refreshCollectionId(CollectionIdentifier identifier) {
        this.collectionMapRefreshInProgress.incrementAndGet();
        long start = System.nanoTime();
        GetCollectionIdRequest request = new GetCollectionIdRequest(this.core.context().environment().timeoutConfig().kvTimeout(), this.core.context(), (RetryStrategy)BestEffortRetryStrategy.INSTANCE, identifier);
        this.core.send(request);
        request.response().whenComplete((response, throwable) -> {
            try {
                Duration duration = Duration.ofNanos(System.nanoTime() - start);
                if (throwable != null) {
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), identifier, (Throwable)throwable, CollectionMapRefreshFailedEvent.Reason.FAILED));
                    return;
                }
                if (response.status().success()) {
                    if (response.collectionId().isPresent()) {
                        long cid = response.collectionId().get();
                        this.collectionMap.put(identifier, UnsignedLEB128.encode(cid));
                        this.eventBus.publish(new CollectionMapRefreshSucceededEvent(duration, this.core.context(), identifier, cid));
                    } else {
                        this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), identifier, null, CollectionMapRefreshFailedEvent.Reason.COLLECTION_ID_NOT_PRESENT));
                    }
                } else {
                    CollectionMapRefreshFailedEvent.Reason reason;
                    CouchbaseException cause = null;
                    if (response.status() == ResponseStatus.UNKNOWN) {
                        reason = CollectionMapRefreshFailedEvent.Reason.NOT_SUPPORTED;
                    } else if (response.status() == ResponseStatus.UNKNOWN_COLLECTION) {
                        reason = CollectionMapRefreshFailedEvent.Reason.UNKNOWN_COLLECTION;
                    } else if (response.status() == ResponseStatus.NO_COLLECTIONS_MANIFEST) {
                        reason = CollectionMapRefreshFailedEvent.Reason.SERVER_HAS_NO_MANIFEST;
                    } else if (response.status() == ResponseStatus.INVALID_REQUEST) {
                        reason = CollectionMapRefreshFailedEvent.Reason.INVALID_REQUEST;
                    } else {
                        cause = new CouchbaseException(response.toString());
                        reason = CollectionMapRefreshFailedEvent.Reason.UNKNOWN;
                    }
                    this.eventBus.publish(new CollectionMapRefreshFailedEvent(duration, this.core.context(), identifier, cause, reason));
                }
            }
            finally {
                this.collectionMapRefreshInProgress.decrementAndGet();
            }
        });
    }

    @Override
    public boolean collectionMapRefreshInProgress() {
        return this.collectionMapRefreshInProgress.get() > 0;
    }

    private void checkAndApplyConfig(BucketConfig newConfig) {
        String name = newConfig.name();
        BucketConfig oldConfig = this.currentConfig.bucketConfig(name);
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.OLD_OR_SAME_REVISION, Optional.empty(), Optional.empty()));
            return;
        }
        if (newConfig.tainted()) {
            this.keyValueRefresher.markTainted(name);
            this.clusterManagerRefresher.markTainted(name);
        } else {
            this.keyValueRefresher.markUntainted(name);
            this.clusterManagerRefresher.markUntainted(name);
        }
        this.eventBus.publish(new BucketConfigUpdatedEvent(this.core.context(), newConfig));
        this.currentConfig.setBucketConfig(newConfig);
        this.checkAlternateAddress();
        this.updateSeedNodeList();
        this.pushConfig();
    }

    private void checkAndApplyConfig(GlobalConfig newConfig) {
        GlobalConfig oldConfig = this.currentConfig.globalConfig();
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            this.eventBus.publish(new ConfigIgnoredEvent(this.core.context(), ConfigIgnoredEvent.Reason.OLD_OR_SAME_REVISION, Optional.empty(), Optional.empty()));
            return;
        }
        this.eventBus.publish(new GlobalConfigUpdatedEvent(this.core.context(), newConfig));
        this.currentConfig.setGlobalConfig(newConfig);
        this.checkAlternateAddress();
        this.updateSeedNodeList();
        this.pushConfig();
    }

    private void updateSeedNodeList() {
        ClusterConfig config = this.currentConfig;
        boolean tlsEnabled = this.core.context().environment().securityConfig().tlsEnabled();
        if (config.globalConfig() != null) {
            Set<SeedNode> seedNodes = Collections.unmodifiableSet(config.globalConfig().portInfos().stream().map(ni -> {
                Map<ServiceType, Integer> ports;
                Map<ServiceType, Integer> map = ports = tlsEnabled ? ni.sslPorts() : ni.ports();
                if (!ports.containsKey((Object)ServiceType.KV)) {
                    return null;
                }
                return SeedNode.create(ni.hostname(), Optional.ofNullable(ports.get((Object)ServiceType.KV)), Optional.ofNullable(ports.get((Object)ServiceType.MANAGER)));
            }).filter(Objects::nonNull).collect(Collectors.toSet()));
            if (!seedNodes.isEmpty()) {
                this.eventBus.publish(new SeedNodesUpdatedEvent(this.core.context(), this.currentSeedNodes(), seedNodes));
                this.setSeedNodes(seedNodes);
            }
            return;
        }
        Set<SeedNode> seedNodes = Collections.unmodifiableSet(config.bucketConfigs().values().stream().flatMap(bc -> bc.nodes().stream()).map(ni -> {
            Map<ServiceType, Integer> ports;
            Map<ServiceType, Integer> map = ports = tlsEnabled ? ni.sslServices() : ni.services();
            if (!ports.containsKey((Object)ServiceType.KV)) {
                return null;
            }
            return SeedNode.create(ni.hostname(), Optional.ofNullable(ports.get((Object)ServiceType.KV)), Optional.ofNullable(ports.get((Object)ServiceType.MANAGER)));
        }).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (!seedNodes.isEmpty()) {
            this.eventBus.publish(new SeedNodesUpdatedEvent(this.core.context(), this.currentSeedNodes(), seedNodes));
            this.setSeedNodes(seedNodes);
        }
    }

    private synchronized void checkAlternateAddress() {
        if (this.alternateAddrChecked.compareAndSet(false, true)) {
            String resolved = DefaultConfigurationProvider.determineNetworkResolution(DefaultConfigurationProvider.extractAlternateAddressInfos(this.currentConfig), this.core.context().environment().ioConfig().networkResolution(), this.currentSeedNodes().stream().map(SeedNode::address).collect(Collectors.toSet()));
            this.core.context().alternateAddress(Optional.ofNullable(resolved));
        }
    }

    public static List<AlternateAddressHolder> extractAlternateAddressInfos(ClusterConfig config) {
        Stream<AlternateAddressHolder> holders = config.globalConfig() != null ? config.globalConfig().portInfos().stream().map(pi -> new AlternateAddressHolder(pi.hostname(), pi.alternateAddresses())) : config.bucketConfigs().values().stream().flatMap(bc -> bc.nodes().stream()).map(ni -> new AlternateAddressHolder(ni.hostname(), ni.alternateAddresses()));
        return holders.collect(Collectors.toList());
    }

    public static String determineNetworkResolution(List<AlternateAddressHolder> nodes, NetworkResolution nr, Set<String> seedHosts) {
        if (nr.equals(NetworkResolution.DEFAULT)) {
            return null;
        }
        if (nr.equals(NetworkResolution.AUTO)) {
            for (AlternateAddressHolder info : nodes) {
                if (seedHosts.contains(info.hostname())) {
                    return null;
                }
                Map<String, AlternateAddress> aa = info.alternateAddresses();
                if (aa == null || aa.isEmpty()) continue;
                for (Map.Entry<String, AlternateAddress> entry : aa.entrySet()) {
                    AlternateAddress alternateAddress = entry.getValue();
                    if (alternateAddress == null || !seedHosts.contains(alternateAddress.hostname())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }
        return nr.name();
    }

    private void pushConfig() {
        this.configsSink.next((Object)this.currentConfig);
    }

    protected Mono<Void> registerRefresher(String bucket) {
        return Mono.defer(() -> {
            BucketConfig config = this.currentConfig.bucketConfig(bucket);
            if (config == null) {
                return Mono.error((Throwable)new CouchbaseException("Bucket for registration does not exist, this is an error! Please report"));
            }
            if (config instanceof CouchbaseBucketConfig) {
                return this.keyValueRefresher.register(bucket);
            }
            return this.clusterManagerRefresher.register(bucket);
        });
    }

    @Override
    public boolean globalConfigLoadInProgress() {
        return this.globalConfigLoadInProgress;
    }

    @Override
    public boolean bucketConfigLoadInProgress() {
        return this.bucketConfigLoadInProgress.get() > 0;
    }

    Set<SeedNode> currentSeedNodes() {
        return this.currentSeedNodes.get();
    }

    private void setSeedNodes(Set<SeedNode> seedNodes) {
        this.currentSeedNodes.set(seedNodes);
        this.seedNodesSink.next(seedNodes);
    }

    public static class AlternateAddressHolder {
        private final String hostname;
        private final Map<String, AlternateAddress> alternateAddresses;

        AlternateAddressHolder(String hostname, Map<String, AlternateAddress> alternateAddresses) {
            this.hostname = hostname;
            this.alternateAddresses = alternateAddresses;
        }

        public String hostname() {
            return this.hostname;
        }

        public Map<String, AlternateAddress> alternateAddresses() {
            return this.alternateAddresses;
        }
    }
}

