/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.analytics;

import com.couchbase.client.core.error.AuthenticationFailureException;
import com.couchbase.client.core.error.CompilationFailureException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DatasetExistsException;
import com.couchbase.client.core.error.DatasetNotFoundException;
import com.couchbase.client.core.error.DataverseExistsException;
import com.couchbase.client.core.error.DataverseNotFoundException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.InternalServerFailureException;
import com.couchbase.client.core.error.JobQueueFullException;
import com.couchbase.client.core.error.LinkNotFoundException;
import com.couchbase.client.core.error.ParsingFailureException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.context.AnalyticsErrorContext;
import com.couchbase.client.core.io.netty.chunk.BaseChunkResponseParser;
import com.couchbase.client.core.json.stream.JsonStreamParser;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class AnalyticsChunkResponseParser
extends BaseChunkResponseParser<AnalyticsChunkHeader, AnalyticsChunkRow, AnalyticsChunkTrailer> {
    private String requestId;
    private Optional<byte[]> signature;
    private Optional<String> clientContextId;
    private String status;
    private byte[] metrics;
    private byte[] warnings;
    private byte[] errors;
    private final JsonStreamParser.Builder parserBuilder = JsonStreamParser.builder().doOnValue("/requestID", v -> {
        this.requestId = v.readString();
    }).doOnValue("/signature", v -> {
        this.signature = Optional.of(v.readBytes());
    }).doOnValue("/clientContextID", v -> {
        this.clientContextId = Optional.of(v.readString());
    }).doOnValue("/results/-", v -> {
        this.markHeaderComplete();
        this.emitRow(new AnalyticsChunkRow(v.readBytes()));
    }).doOnValue("/status", v -> {
        this.markHeaderComplete();
        this.status = v.readString();
    }).doOnValue("/metrics", v -> {
        this.metrics = v.readBytes();
    }).doOnValue("/errors", v -> {
        this.errors = v.readBytes();
        this.failRows(this.errorsToThrowable(this.errors));
    }).doOnValue("/warnings", v -> {
        this.warnings = v.readBytes();
    });

    @Override
    protected void doCleanup() {
        this.requestId = null;
        this.signature = Optional.empty();
        this.clientContextId = Optional.empty();
        this.status = null;
        this.metrics = null;
        this.warnings = null;
        this.errors = null;
    }

    @Override
    protected JsonStreamParser.Builder parserBuilder() {
        return this.parserBuilder;
    }

    @Override
    public Optional<AnalyticsChunkHeader> header(boolean lastChunk) {
        return this.isHeaderComplete() ? Optional.of(new AnalyticsChunkHeader(this.requestId, this.clientContextId, this.signature)) : Optional.empty();
    }

    @Override
    public Optional<CouchbaseException> error() {
        return Optional.ofNullable(this.errors).map(this::errorsToThrowable);
    }

    private CouchbaseException errorsToThrowable(byte[] bytes) {
        List<ErrorCodeAndMessage> errors = bytes.length == 0 ? Collections.emptyList() : ErrorCodeAndMessage.fromJsonArray(bytes);
        AnalyticsErrorContext errorContext = new AnalyticsErrorContext(this.requestContext(), errors);
        if (errors.size() >= 1) {
            int code = errors.get(0).code();
            if (code >= 25000 && code < 26000) {
                return new InternalServerFailureException(errorContext);
            }
            if (code >= 20000 && code < 21000) {
                return new AuthenticationFailureException("Could not authenticate analytics query", errorContext, null);
            }
            if (code == 23000 || code == 23003) {
                return new TemporaryFailureException(errorContext);
            }
            if (code == 23007) {
                return new JobQueueFullException(errorContext);
            }
            if (code == 24000) {
                return new ParsingFailureException(errorContext);
            }
            if (code == 24006) {
                return new LinkNotFoundException(errorContext);
            }
            if (code == 24040) {
                return new DatasetExistsException(errorContext);
            }
            if (code == 24044 || code == 24045 || code == 24025) {
                return new DatasetNotFoundException(errorContext);
            }
            if (code == 24034) {
                return new DataverseNotFoundException(errorContext);
            }
            if (code == 24039) {
                return new DataverseExistsException(errorContext);
            }
            if (code == 24047) {
                return new IndexNotFoundException(errorContext);
            }
            if (code == 24048) {
                return new IndexExistsException(errorContext);
            }
            if (code > 24000 && code < 25000) {
                return new CompilationFailureException(errorContext);
            }
        }
        return new CouchbaseException("Unknown analytics error", errorContext);
    }

    @Override
    public void signalComplete() {
        this.completeRows();
        this.completeTrailer(new AnalyticsChunkTrailer(this.status, this.metrics, Optional.ofNullable(this.warnings), Optional.ofNullable(this.errors)));
    }
}

