/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.io.IoContext;
import java.time.Duration;

public class UnknownResponseReceivedEvent
extends AbstractEvent {
    private final byte[] response;

    public UnknownResponseReceivedEvent(IoContext context, byte[] response) {
        super(Event.Severity.WARN, Event.Category.IO, Duration.ZERO, (Context)context);
        this.response = response;
    }

    public byte[] response() {
        return this.response;
    }

    @Override
    public String description() {
        return "Received a response with no matching opaque/request: \n" + ByteBufUtil.prettyHexDump(Unpooled.copiedBuffer(this.response)) + "\n";
    }
}

